/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.db2.zos;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.db2.AbstractDb2ObOracle22xColumnConverter;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosColumn;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosSequence;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xColumn;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;

@Conversion(sourceDbType=DbType.DB2ZOS_1000, targetDbType=DbType.OBORACLE_22)
public class Db2ZosObOracle22xColumnConverter
extends AbstractDb2ObOracle22xColumnConverter<Db2ZosColumn, ObOracle22xColumn> {
    public Db2ZosObOracle22xColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xColumn convertByRule(Db2ZosColumn source) {
        String foreignKey;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xColumn column = new ObOracle22xColumn(schema);
        column.setObjectName(source.getObjectName());
        column.setColumnName(source.getColumnName());
        column.setNullable(source.getNullable());
        column.setColumnComment(source.getColumnComment());
        column.setOrdinalPosition(source.getOrdinalPosition());
        if ("P".equals(source.getHidden())) {
            column.setHiddenColumn("YES");
        }
        String defaultType = source.getDefaultType();
        String generateType = source.getGenerateMapping().get(defaultType);
        if ("B".equals(defaultType) || "Y".equals(defaultType)) {
            String columnDefault = source.getColumnDefault();
            if (UNSUPPORTED_DEFAULTS.contains(columnDefault)) {
                ChangeUtils.info(ObjectType.TABLE, column.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, column.getWrappedName() + " DEFAULT " + columnDefault + " -> [NULL]");
            } else {
                column.setColumnDefault(DEFAULT_MAPPING.getOrDefault(columnDefault, columnDefault));
            }
        } else if ("I".equals(defaultType) || "J".equals(defaultType)) {
            Db2ZosSequence identityExpr = source.getIdentityExpr();
            if (identityExpr != null) {
                ChangeUtils.warn(ObjectType.TABLE, column.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, column.getWrappedName() + generateType + identityExpr.buildIdentityGrammar() + " -> [NULL]", "-- CREATE SEQUENCE xxx " + identityExpr.buildSequenceGrammar());
            }
        } else {
            ChangeUtils.warn(ObjectType.TABLE, column.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, column.getWrappedName() + generateType + " -> [NULL]");
        }
        String dataType = source.getDataType().trim();
        if (("CHARACTER".equals(dataType) || "VARCHAR".equals(dataType)) && StringUtils.isNotBlank((CharSequence)(foreignKey = source.getForeignKey()))) {
            Long dataLength = source.getDataLength();
            ChangeUtils.info(ObjectType.TABLE, column.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, column.getWrappedName() + " " + dataType + "(" + source.getDataLength() + ") FOR BIT DATA -> " + COLUMN_TYPE_MAPPING.getOrDefault(dataType, dataType) + " (" + dataLength + " BYTE)");
        }
        return super.doTranslate(column, source);
    }
}

