/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.db2.zos;

import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosIndex;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosIndexPartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xIndex;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xIndexPartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleIndexPartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import java.util.List;

@Conversion(sourceDbType=DbType.DB2ZOS_1000, targetDbType=DbType.OBORACLE_22)
public class Db2ZosObOracle22xIndexConverter
extends AbstractRuleBasedConverter<Db2ZosIndex, ObOracle22xIndex> {
    public Db2ZosObOracle22xIndexConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xIndex convertByRule(Db2ZosIndex source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xIndex target = new ObOracle22xIndex(schema);
        List<KeyColumn> indexColumns = source.getIndexColumns();
        String indexType = source.getIndexType();
        target.setIndexName(source.getIndexName());
        target.setIncludeColumn(source.getIndexComment());
        target.setIndexSchema(source.getIndexSchema());
        target.getIndexColumns().addAll(indexColumns);
        target.setUniqueness(source.getUniqueness());
        if ("D".equals(indexType)) {
            ObOracle22xIndexPartition partition = new ObOracle22xIndexPartition(schema);
            partition.setLocality("LOCAL");
            target.setIndexPartition(partition);
        } else if ("P".equals(indexType)) {
            ObOracle22xIndexPartition partition = new ObOracle22xIndexPartition(schema);
            partition.setLocality("GLOBAL");
            partition.setPartitioningType("RANGE");
            partition.setPartitionCount(source.getPartitions());
            partition.setPartitioningKeyCount(indexColumns.size());
            for (KeyColumn indexColumn : indexColumns) {
                AbstractOracleIndexPartition.OracleIndexPartitionColumn column = new AbstractOracleIndexPartition.OracleIndexPartitionColumn();
                column.setName(source.getSchemaObjectName());
                column.setObjectType(ObjectType.INDEX.name());
                column.setColumnName(indexColumn.getColumnName());
                column.setColumnPosition(indexColumn.getOrdinalPosition());
                partition.getIndexPartitionColumns().add(column);
            }
            for (Db2ZosIndexPartition.Db2ZosIndexPartitionItem partitionItem : source.getIndexPartition().getPartitionItems()) {
                AbstractOracleIndexPartition.OracleIndexPartitionItem item = new AbstractOracleIndexPartition.OracleIndexPartitionItem();
                item.setPartitionName(String.valueOf(partitionItem.getPartition()));
                item.setHighValue(partitionItem.getLimitKey());
                partition.getIndexPartitions().add(item);
            }
            target.setIndexPartition(partition);
        }
        return target;
    }
}

