/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.db2.zos;

import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2TablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.zos.Db2ZosTablePartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTablePartition;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import java.util.Collection;
import java.util.Set;

@Conversion(sourceDbType=DbType.DB2ZOS_1000, targetDbType=DbType.OBORACLE_22)
public class Db2ZosObOracle22xPartitionConverter
extends AbstractRuleBasedConverter<Db2ZosTablePartition, ObOracle22xTablePartition> {
    public Db2ZosObOracle22xPartitionConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xTablePartition convertByRule(Db2ZosTablePartition source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xTablePartition partition = new ObOracle22xTablePartition(schema);
        String partitionType = source.getPartitionType();
        if ("G".equals(partitionType)) {
            partition.setPartitioningType("SIZE");
        } else if ("R".equals(partitionType)) {
            Collection<AbstractDb2TablePartition.Db2TablePartitionColumn> partitionColumns = source.getPartitionColumns();
            for (AbstractDb2TablePartition.Db2TablePartitionColumn origin : partitionColumns) {
                AbstractOracleTablePartition.OracleTablePartitionColumn column = new AbstractOracleTablePartition.OracleTablePartitionColumn();
                column.setName(origin.getName());
                column.setColumnName(origin.getPartitionExpression());
                column.setColumnPosition(origin.getPartitionKeySeq());
                partition.getTablePartitionColumns().add(column);
            }
            partition.setPartitioningType("RANGE");
            Set<AbstractDb2TablePartition.Db2TablePartitionItem> partitionItems = source.getPartitionItems();
            partition.setPartitionCount(partitionItems.size());
            partition.setPartitioningKeyCount(partitionColumns.size());
            for (AbstractDb2TablePartition.Db2TablePartitionItem partitionItem : source.getPartitionItems()) {
                AbstractOracleTablePartition.OracleTablePartitionItem item = new AbstractOracleTablePartition.OracleTablePartitionItem();
                item.setTableName(source.getSchemaObjectName());
                item.setPartitionName(String.valueOf(partitionItem.getPartitionNumber()));
                item.setHighValue(partitionItem.getHighValue());
                partition.getTablePartitions().add(item);
            }
        }
        return partition;
    }
}

