/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.lindorm.hbase;

import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.lindorm.hbase.LindormHbaseTable;
import com.oceanbase.obtools.dbdiff.model.obkv.ObKVColumn;
import com.oceanbase.obtools.dbdiff.model.obkv.ObKVColumnFamily;
import com.oceanbase.obtools.dbdiff.model.obkv.ObKVPrimary;
import com.oceanbase.obtools.dbdiff.model.obkv.ObKVSchema;
import com.oceanbase.obtools.dbdiff.model.obkv.ObKVTable;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import java.util.List;

@Conversion(sourceDbType=DbType.LINDORM_HASE_2019, targetDbType=DbType.OBKV_22X)
public class LindormHbaseObKVTableConverter
extends AbstractRuleBasedConverter<LindormHbaseTable, ObKVTable> {
    public LindormHbaseObKVTableConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObKVTable convertByRule(LindormHbaseTable source) {
        AbstractSchema schema = source.getSchema();
        Global global = schema.getGlobal();
        DbType dbType = schema.getDbType();
        String schemaName = schema.getSchemaName();
        ObKVSchema targetSchema = new ObKVSchema(global, dbType, schemaName);
        ObKVTable target = new ObKVTable(targetSchema);
        target.setObjectName(source.getObjectName());
        List<LindormHbaseTable.ColumnFamily> columnFamilies = source.getColumnFamilies();
        for (LindormHbaseTable.ColumnFamily cf : columnFamilies) {
            String cfName = cf.getColumnFamilyName();
            ObKVColumnFamily targetCf = new ObKVColumnFamily(targetSchema);
            targetCf.setTable(target);
            targetCf.setObjectName(cfName);
            targetCf.setTtl(cf.getTtl());
            targetCf.setMaxVersion(cf.getMaxVersion());
            targetCf.setMinVersion(cf.getMinVersion());
            this.fillObKVTableMeta(targetCf);
            target.getColumnFamilyMapping().put(targetCf.getObjectName(), targetCf);
        }
        return target;
    }

    private void fillObKVTableMeta(ObKVColumnFamily columnFamily) {
        AbstractSchema schema = columnFamily.getSchema();
        ObKVColumn columnK = new ObKVColumn(schema);
        columnK.setColumnName("K");
        columnK.setColumnType("varbinary(4096)");
        ObKVColumn columnQ = new ObKVColumn(schema);
        columnQ.setColumnName("Q");
        columnQ.setColumnType("varbinary(4096)");
        ObKVColumn columnT = new ObKVColumn(schema);
        columnT.setColumnName("T");
        columnT.setColumnType("bigint");
        ObKVColumn columnV = new ObKVColumn(schema);
        columnV.setColumnName("V");
        columnV.setColumnType("mediumblob");
        ObKVPrimary primary = new ObKVPrimary(schema);
        primary.getConstraintColumns().add(new KeyColumn("K", 1, "ASC"));
        primary.getConstraintColumns().add(new KeyColumn("Q", 2, "ASC"));
        primary.getConstraintColumns().add(new KeyColumn("T", 3, "ASC"));
        columnFamily.getColumnMapping().put(columnK.getColumnName(), columnK);
        columnFamily.getColumnMapping().put(columnQ.getColumnName(), columnQ);
        columnFamily.getColumnMapping().put(columnT.getColumnName(), columnT);
        columnFamily.getColumnMapping().put(columnV.getColumnName(), columnV);
        columnFamily.setPrimaryKey(primary);
    }
}

