/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.lindorm.widecolumn;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.lindorm.widecolumn.LindormWildColumnColumn;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xColumn;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@Conversion(sourceDbType=DbType.LINDORM_WILDCOLUMN_2536, targetDbType=DbType.OBMYSQL_14)
public class LindormWildColumnColumnObMysqlColumnConverter
extends AbstractRuleBasedConverter<LindormWildColumnColumn, ObMySql14xColumn> {
    private static final Map<String, String> DATA_TYPE_MAPPING = new HashMap<String, String>();

    public LindormWildColumnColumnObMysqlColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObMySql14xColumn convertByRule(LindormWildColumnColumn source) {
        AbstractSchema schema = source.getSchema();
        Global global = schema.getGlobal();
        DbType dbType = schema.getDbType();
        String schemaName = schema.getSchemaName();
        ObMySql14xSchema targetSchema = new ObMySql14xSchema(global, dbType, schemaName);
        targetSchema.setOriginDbType(source.getOriginDbType());
        ObMySql14xColumn target = new ObMySql14xColumn(targetSchema);
        target.setObjectName(source.getObjectName());
        target.setColumnName(source.getColumnName());
        String originDataType = source.getDataType().toUpperCase(Locale.getDefault());
        String dataType = DATA_TYPE_MAPPING.getOrDefault(originDataType, originDataType);
        String originColumnType = source.getColumnType();
        StringBuilder sb = new StringBuilder();
        switch (dataType) {
            case "DECIMAL": {
                Integer precision = source.getNumericPrecision();
                Integer scale = source.getNumericScale();
                target.setNumericPrecision(precision);
                target.setNumericScale(Math.min(30, scale));
                sb.append("(").append(target.getNumericPrecision()).append(",").append(target.getNumericScale()).append(")");
                break;
            }
            case "VARCHAR": {
                target.setCharacterMaximumLength(65535L);
                if (source.isIndexed()) {
                    target.setCharacterMaximumLength(4096L);
                }
                sb.append("(").append(target.getCharacterMaximumLength()).append(")");
                break;
            }
            case "JSON": {
                if ((!DbType.OBMYSQL_322.getType().equals(dbType.getType()) || !DbType.OBMYSQL_322.isSubsequent(dbType)) && (!DbType.OBMYSQL_CE_313.getType().equals(dbType.getType()) || !DbType.OBMYSQL_CE_313.isSubsequent(dbType))) break;
                dataType = "LONGTEXT";
                break;
            }
            case "BINARY": {
                Integer length = source.getCharacterMaximumLength();
                if (length == null) break;
                if (length <= 256) {
                    dataType = "BINARY";
                    sb.append("(").append(length).append(")");
                    break;
                }
                if (length <= 65535) {
                    dataType = "VARBINARY";
                    sb.append("(").append(length).append(")");
                    break;
                }
                dataType = "BLOB";
                break;
            }
        }
        target.setDataType(dataType);
        target.setColumnType(dataType + sb);
        if (!originColumnType.equalsIgnoreCase(target.getColumnType())) {
            ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, source.getWrappedName() + " " + originColumnType + " -> " + target.getWrappedName() + " " + target.getColumnType());
        }
        return target;
    }

    static {
        DATA_TYPE_MAPPING.put("CHAR", "VARCHAR");
        DATA_TYPE_MAPPING.put("VARBINARY", "BLOB");
    }
}

