/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.lindorm.widecolumn;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.lindorm.widecolumn.LindormWildColumnIndex;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xIndex;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.Locale;

@Conversion(sourceDbType=DbType.LINDORM_WILDCOLUMN_2536, targetDbType=DbType.OBMYSQL_14)
public class LindormWildColumnIndexObMysqlIndexConverter
extends AbstractRuleBasedConverter<LindormWildColumnIndex, ObMySql14xIndex> {
    public LindormWildColumnIndexObMysqlIndexConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObMySql14xIndex convertByRule(LindormWildColumnIndex source) {
        if (!"SECONDARY".equalsIgnoreCase(source.getIndexType())) {
            ChangeUtils.warn(ObjectType.TABLE, source.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, "create " + source.getIndexType().toLowerCase(Locale.getDefault()) + " index " + source.getSchemaObjectName() + " on " + source.getSchemaObjectName() + source.joinIndexColumns() + " -> NULL");
            return null;
        }
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObMySql14xSchema targetSchema = new ObMySql14xSchema(global, dbType, schemaName);
        targetSchema.setOriginDbType(source.getOriginDbType());
        ObMySql14xIndex target = new ObMySql14xIndex(targetSchema);
        target.setObjectName(source.getObjectName());
        target.setIndexName(source.getIndexName());
        target.getIndexColumns().addAll(source.getIndexColumns());
        return target;
    }
}

