/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.mysql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.constants.JdbcType;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlColumn;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xColumn;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractMySqlObOracle22xColumnConverter<S, D>
extends AbstractRuleBasedConverter<S, D> {
    private static final Map<String, String> DATA_TYPE_MAPPING = new HashMap<String, String>();

    public AbstractMySqlObOracle22xColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    protected ObOracle22xColumn convertInternal(AbstractMySqlColumn source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xColumn column = new ObOracle22xColumn(schema);
        column.setObjectName(source.getObjectName());
        column.setColumnName(source.getColumnName());
        column.setNullable(source.getNullable());
        String columnName = column.getColumnName();
        String columnType = source.getColumnType();
        StringBuilder sb = new StringBuilder();
        sb.append(columnName).append(" ").append(columnType);
        String extra = source.getExtra();
        if (StringUtils.isNotBlank((CharSequence)extra) && !"DEFAULT_GENERATED".equals(extra)) {
            sb.append(" ").append(extra);
        }
        sb.append(" -> ").append(columnName).append(" ");
        String dataType = source.getDataType();
        switch (dataType = dataType.trim().toUpperCase(Locale.getDefault())) {
            case "BIT": {
                Integer bitLength = source.getNumericPrecision();
                column.setDataLength((long)(bitLength / 8) + 1L);
                column.setDataType("RAW");
                sb.append("RAW").append("(").append(column.getDataLength()).append(")");
                break;
            }
            case "CHAR": 
            case "VARCHAR": {
                column.setDataType(DATA_TYPE_MAPPING.getOrDefault(dataType, dataType));
                column.setCharUsed("B");
                Long characterOctetLength = source.getCharacterOctetLength();
                if (characterOctetLength == null || characterOctetLength == 0L) {
                    column.setCharLength(1L);
                } else {
                    column.setCharLength(characterOctetLength);
                }
                sb.append(column.getDataType()).append("(").append(column.getCharLength()).append(" BYTE)");
                break;
            }
            case "BINARY": {
                Long characterOctetLength = source.getCharacterOctetLength();
                column.setDataType("RAW");
                if (characterOctetLength == null || characterOctetLength == 0L) {
                    column.setDataLength(1L);
                } else {
                    column.setDataLength(characterOctetLength);
                }
                sb.append("RAW").append("(").append(column.getDataLength()).append(")");
                break;
            }
            case "DECIMAL": 
            case "NUMERIC": {
                column.setDataType("NUMBER");
                column.setDataPrecision(source.getNumericPrecision());
                column.setDataScale(source.getNumericScale());
                sb.append("NUMBER");
                sb.append("(").append(column.getDataPrecision()).append(",").append(column.getDataScale()).append(")");
                break;
            }
            case "DATETIME": 
            case "TIMESTAMP": {
                Integer dateTimePrecision = source.getDateTimePrecision();
                if (dateTimePrecision == null || dateTimePrecision == 0) {
                    column.setDataType("TIMESTAMP");
                } else {
                    column.setDataType("TIMESTAMP(" + dateTimePrecision + ")");
                }
                sb.append(column.getDataType());
                break;
            }
            case "JSON": {
                if (DbType.OBORACLE_410.isSubsequent(dbType)) {
                    column.setDataType("VARCHAR2(32767)");
                } else {
                    column.setDataType("JSON");
                }
                sb.append(column.getDataType());
                break;
            }
            default: {
                column.setDataType(DATA_TYPE_MAPPING.getOrDefault(dataType, dataType));
                sb.append(column.getDataType());
            }
        }
        String schemaObjectName = column.getSchemaObjectName();
        this.resolveDefaultClause(source, column);
        column.setColumnComment(source.getColumnComment());
        if (columnType.contains("unsigned")) {
            column.setInlineCheckGrammar("CHECK(" + column.getWrappedName() + " >= 0)");
            sb.append(" ").append(column.getInlineCheckGrammar());
        }
        if (columnType.contains("zerofill") && column.getColumnDefault() == null) {
            column.setColumnDefault("0");
        }
        if (column.getColumnDefault() != null) {
            sb.append(" DEFAULT ").append(column.getColumnDefault());
        }
        String createSeq = null;
        if ("auto_increment".equalsIgnoreCase(extra)) {
            createSeq = "-- CREATE SEQUENCE xxx START WITH 1 INCREMENT BY 1 ... for " + schemaObjectName;
        }
        ChangeUtils.warn(ObjectType.TABLE, schemaObjectName, ChangeInfo.ChangeType.CONVERT, sb.toString(), createSeq);
        return column;
    }

    protected void resolveDefaultClause(AbstractMySqlColumn source, ObOracle22xColumn column) {
        String expr;
        DbType originDbType = source.getOriginDbType();
        boolean isObMySql = DbType.OBMYSQL_14.getType().equals(originDbType.getType());
        if (isObMySql && originDbType.isPrior(DbType.OBMYSQL_2250)) {
            ChangeUtils.info(ObjectType.TABLE, source.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, source.getColumnName() + " GENERATED ALWAYS AS ... maybe lost OBMYSQL v2250-");
        }
        if (StringUtils.isNotBlank((CharSequence)(expr = source.getGenerationExpression()))) {
            if ((expr = expr.trim()).startsWith("(") && expr.endsWith(")")) {
                expr = expr.substring(1, expr.length() - 1);
            }
            column.setColumnDefault(expr.replaceAll("[`]", ""));
            column.setVirtualColumn("YES");
            return;
        }
        String columnDefault = source.getColumnDefault();
        if (columnDefault == null) {
            return;
        }
        String dataType = source.getDataType();
        if ("BIT".equalsIgnoreCase(dataType)) {
            if (isObMySql && originDbType.isSubsequent(DbType.OBMYSQL_211)) {
                column.setColumnDefault(columnDefault);
            } else {
                ChangeUtils.info(ObjectType.TABLE, source.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, source.getColumnName() + " BIT DEFAULT b'" + columnDefault + "' -> NULL");
                return;
            }
        }
        if (JdbcType.isDateType(dataType)) {
            if ((columnDefault = columnDefault.toLowerCase(Locale.getDefault())).startsWith("current_timestamp")) {
                column.setColumnDefault("sysdate");
            } else {
                column.setColumnDefault("'" + columnDefault.replace("0000-00-00", "1970-01-01") + "'");
            }
        } else if (JdbcType.isStringType(dataType)) {
            column.setColumnDefault(this.escapeColumnDefault("'" + columnDefault + "'"));
        }
    }

    public String escapeColumnDefault(String colDefault) {
        if (colDefault.startsWith("'") && colDefault.endsWith("'") && colDefault.length() > 1) {
            colDefault = colDefault.substring(1, colDefault.length() - 1).replace("'", "''");
            return "'" + colDefault + "'";
        }
        return colDefault;
    }

    static {
        DATA_TYPE_MAPPING.put("TINYINT", "NUMBER(3,0)");
        DATA_TYPE_MAPPING.put("SMALLINT", "NUMBER(5,0)");
        DATA_TYPE_MAPPING.put("MEDIUMINT", "NUMBER(7,0)");
        DATA_TYPE_MAPPING.put("INT", "NUMBER(10,0)");
        DATA_TYPE_MAPPING.put("INTEGER", "NUMBER(10,0)");
        DATA_TYPE_MAPPING.put("BIGINT", "NUMBER(19,0)");
        DATA_TYPE_MAPPING.put("FLOAT", "BINARY_FLOAT");
        DATA_TYPE_MAPPING.put("REAL", "BINARY_DOUBLE");
        DATA_TYPE_MAPPING.put("DOUBLE", "BINARY_DOUBLE");
        DATA_TYPE_MAPPING.put("DOUBLE PRECISION", "BINARY_DOUBLE");
        DATA_TYPE_MAPPING.put("TINYBLOB", "BLOB");
        DATA_TYPE_MAPPING.put("MEDIUMBLOB", "BLOB");
        DATA_TYPE_MAPPING.put("BLOB", "BLOB");
        DATA_TYPE_MAPPING.put("LONGBLOB", "BLOB");
        DATA_TYPE_MAPPING.put("TINYTEXT", "CLOB");
        DATA_TYPE_MAPPING.put("MEDIUMTEXT", "CLOB");
        DATA_TYPE_MAPPING.put("TEXT", "CLOB");
        DATA_TYPE_MAPPING.put("LONGTEXT", "CLOB");
        DATA_TYPE_MAPPING.put("DATE", "DATE");
        DATA_TYPE_MAPPING.put("TIME", "DATE");
        DATA_TYPE_MAPPING.put("YEAR", "NUMBER(4)");
        DATA_TYPE_MAPPING.put("BOOLEAN", "CHAR(1)");
        DATA_TYPE_MAPPING.put("SET", "VARCHAR2(32767)");
        DATA_TYPE_MAPPING.put("ENUM", "VARCHAR2(32767)");
        DATA_TYPE_MAPPING.put("VARCHAR", "VARCHAR2");
        DATA_TYPE_MAPPING.put("VARBINARY", "BLOB");
    }
}

