/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.mysql;

import com.google.common.collect.Lists;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTablePartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTablePartition;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMySqlObOracle22xPartitionConverter<S, D>
extends AbstractRuleBasedConverter<S, D> {
    private static final Map<String, String> PARTITION_TYPE_MAP = new HashMap<String, String>();

    public AbstractMySqlObOracle22xPartitionConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    protected ObOracle22xTablePartition convertInternal(AbstractMySqlTablePartition source) {
        Map<String, List<AbstractMySqlTablePartition.MySqlPartitionItem>> subPartitonMap;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xTablePartition target = new ObOracle22xTablePartition(schema);
        target.setObjectName(source.getObjectName());
        String partitionMethod = source.getPartitionMethod();
        String partitionExpr = source.getPartitionExpression();
        if (StringUtils.isNotBlank((CharSequence)partitionMethod) && StringUtils.isBlank((CharSequence)partitionExpr)) {
            ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, "PARTITION BY " + partitionMethod + "(" + partitionExpr + ") -> [NULL]");
            return null;
        }
        String subPartitionMethod = source.getSubPartitionMethod();
        String subPartitionExpr = source.getSubPartitionExpression();
        if (StringUtils.isNotBlank((CharSequence)subPartitionMethod) && StringUtils.isBlank((CharSequence)subPartitionExpr)) {
            ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, "SUBPARTITION BY " + subPartitionMethod + "(" + partitionExpr + ") -> [NULL]");
            return null;
        }
        target.setPartitioningType(PARTITION_TYPE_MAP.get(partitionMethod));
        target.setSubPartitioningType(PARTITION_TYPE_MAP.get(subPartitionMethod));
        target.getTablePartitionColumns().addAll(this.parsePartColumns(source, partitionExpr));
        target.setPartitioningKeyCount(target.getTablePartitionColumns().size());
        target.getTableSubPartitionColumns().addAll(this.parsePartColumns(source, subPartitionExpr));
        target.setSubPartitioningKeyCount(target.getTableSubPartitionColumns().size());
        Collection<AbstractMySqlTablePartition.MySqlPartitionItem> tablePartitions = source.getTablePartitions();
        target.setPartitionCount(tablePartitions.size());
        if (CollectionUtils.isNotEmpty(tablePartitions)) {
            for (AbstractMySqlTablePartition.MySqlPartitionItem item : tablePartitions) {
                AbstractOracleTablePartition.OracleTablePartitionItem item2 = new AbstractOracleTablePartition.OracleTablePartitionItem();
                item2.setPartitionName(item.getPartitionName());
                item2.setPartitionPosition(item.getPartitionOrdinalPosition());
                item2.setHighValue(item.getPartitionDescription());
                target.getTablePartitions().add(item2);
            }
        }
        if (MapUtils.isNotEmpty(subPartitonMap = source.getTableSubPartitionMapping())) {
            target.setDefSubPartitionCount(1);
        }
        return target;
    }

    protected Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> parsePartColumns(AbstractMySqlTablePartition source, String expr) {
        if (StringUtils.isBlank((CharSequence)expr)) {
            return Lists.newArrayList();
        }
        expr = expr.replaceAll("[`\"]", "").trim();
        Set<String> columnSet = source.getColumnSet();
        ArrayList<AbstractOracleTablePartition.OracleTablePartitionColumn> partitionColumns = new ArrayList<AbstractOracleTablePartition.OracleTablePartitionColumn>();
        ArrayList exprs = Lists.newArrayList((Object[])new String[]{expr});
        if (expr.contains(",")) {
            exprs = Lists.newArrayList((Object[])expr.split(","));
        }
        for (int i = 0; i < exprs.size(); ++i) {
            AbstractOracleTablePartition.OracleTablePartitionColumn column = new AbstractOracleTablePartition.OracleTablePartitionColumn();
            column.setName(source.getObjectName());
            expr = (String)exprs.get(i);
            column.setColumnName(expr);
            column.setColumnPosition(i + 1);
            column.setExpression(!columnSet.contains(expr));
            partitionColumns.add(column);
        }
        return partitionColumns;
    }

    static {
        PARTITION_TYPE_MAP.put("HASH", "HASH");
        PARTITION_TYPE_MAP.put("LIST", "LIST");
        PARTITION_TYPE_MAP.put("RANGE", "RANGE");
        PARTITION_TYPE_MAP.put("KEY", "HASH");
        PARTITION_TYPE_MAP.put("LINEAR KEY", "HASH");
        PARTITION_TYPE_MAP.put("LINEAR HASH", "HASH");
        PARTITION_TYPE_MAP.put("LIST COLUMNS", "LIST");
        PARTITION_TYPE_MAP.put("RANGE COLUMNS", "RANGE");
    }
}

