/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.mysql56;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.mysql.AbstractSubPartDefinitionClearupConverter;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Index;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xIndex;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;

@Conversion(sourceDbType=DbType.MYSQL_56, targetDbType=DbType.OBORACLE_22)
public class MySql56ObOracle22xIndexConverter
extends AbstractSubPartDefinitionClearupConverter<MySql56Index, ObOracle22xIndex> {
    public MySql56ObOracle22xIndexConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xIndex convertByRule(MySql56Index source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        String indexType = source.getIndexType();
        ObOracle22xIndex target = new ObOracle22xIndex(schema);
        target.setObjectName(source.getObjectName());
        target.setIndexType(indexType);
        String indexName = source.getIndexName();
        if (global.isDisableDuplicated()) {
            String newIndexName = "idx_" + source.getSchemaName() + "_" + source.getObjectName() + "_" + source.getIndexColumns().stream().map(KeyColumn::getColumnName).collect(Collectors.joining("_"));
            target.setIndexName(newIndexName.toUpperCase(Locale.getDefault()));
            ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "INDEX `" + indexName + "` -> INDEX \"" + target.getIndexName() + "\"");
        } else {
            target.setIndexName(indexName);
        }
        Collection keyColumns = source.getIndexColumns().stream().peek(s -> {
            if (s.isExpression()) {
                s.setColumnName(s.getColumnName().replace("`", "\""));
            }
        }).collect(Collectors.toCollection(ArrayList::new));
        boolean isChanged = keyColumns.stream().anyMatch(e -> StringUtils.isNotBlank((CharSequence)e.getSubPart()));
        StringBuilder origin = new StringBuilder("create");
        if ("FULLTEXT".equalsIgnoreCase(indexType)) {
            origin.append(" fulltext");
            isChanged |= true;
        }
        origin.append(" index ").append(source.getWrappedIndexName());
        origin.append(" on ").append(source.getSchemaObjectName()).append((CharSequence)source.joinIndexColumns());
        target.getIndexColumns().addAll(this.removeSubParts(keyColumns));
        if (isChanged) {
            String schemaObjectName = target.getSchemaObjectName();
            ChangeUtils.warn(ObjectType.TABLE, schemaObjectName, ChangeInfo.ChangeType.CONVERT, origin + " -> CREATE INDEX " + target.getWrappedIndexName() + " ON " + schemaObjectName + target.joinIndexColumns());
        }
        return target;
    }
}

