/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.mysql56;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.mysql.AbstractSubPartDefinitionClearupConverter;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56PrimaryKey;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.List;
import java.util.Locale;

@Conversion(sourceDbType=DbType.MYSQL_56, targetDbType=DbType.OBORACLE_22)
public class MySql56ObOracle22xPrimaryKeyConverter
extends AbstractSubPartDefinitionClearupConverter<MySql56PrimaryKey, ObOracle22xPrimaryKey> {
    public MySql56ObOracle22xPrimaryKeyConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xPrimaryKey convertByRule(MySql56PrimaryKey source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        String constraintName = source.getConstraintName();
        ObOracle22xPrimaryKey target = new ObOracle22xPrimaryKey(schema);
        target.setObjectName(source.getObjectName());
        if (global.isDisableDuplicated() && "PRIMARY".equals(constraintName)) {
            String newConstraintName = "pk_" + source.getSchemaName() + "_" + source.getObjectName();
            target.setConstraintName(newConstraintName.toUpperCase(Locale.getDefault()));
            ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "PRIMARY KEY -> CONSTRAINT \"" + target.getConstraintName() + "\" PRIMARY KEY");
        } else {
            target.setConstraintName(constraintName);
        }
        List<KeyColumn> keyColumns = source.getConstraintColumns();
        boolean hasSubPart = keyColumns.stream().anyMatch(e -> StringUtils.isNotBlank((CharSequence)e.getSubPart()));
        if (hasSubPart) {
            target.getConstraintColumns().addAll(this.removeSubParts(keyColumns));
        } else {
            target.getConstraintColumns().addAll(keyColumns);
        }
        if (hasSubPart) {
            StringBuilder origin = new StringBuilder();
            origin.append("PRIMARY KEY").append((CharSequence)source.joinConstraintColumns());
            ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, origin + " -> PRIMARY KEY" + target.joinConstraintColumns());
        }
        return target;
    }
}

