/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.mysql56;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.mysql.AbstractSubPartDefinitionClearupConverter;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56UniqueKey;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xUniqueKey;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;

@Conversion(sourceDbType=DbType.MYSQL_56, targetDbType=DbType.OBORACLE_22)
public class MySql56ObOracle22xUniqueKeyConverter
extends AbstractSubPartDefinitionClearupConverter<MySql56UniqueKey, ObOracle22xUniqueKey> {
    public MySql56ObOracle22xUniqueKeyConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xUniqueKey convertByRule(MySql56UniqueKey source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xUniqueKey target = new ObOracle22xUniqueKey(schema);
        target.setObjectName(source.getObjectName());
        String constraintName = source.getConstraintName();
        if (global.isDisableDuplicated()) {
            String newConstraintName = "uk_" + source.getSchemaName() + "_" + source.getObjectName() + "_" + source.getConstraintColumns().stream().map(KeyColumn::getColumnName).collect(Collectors.joining("_"));
            if (newConstraintName.length() > 128) {
                newConstraintName = "uk_" + source.getSchemaName() + "_" + source.getObjectName() + "_" + UUID.randomUUID();
            }
            target.setConstraintName(newConstraintName.toUpperCase(Locale.getDefault()));
            ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "CONSTRAINT `" + constraintName + "` UNIQUE -> CONSTRAINT \"" + target.getConstraintName() + "\" UNIQUE");
        } else {
            target.setConstraintName(constraintName);
        }
        List<KeyColumn> keyColumns = source.getConstraintColumns();
        boolean hasSubPart = keyColumns.stream().anyMatch(e -> StringUtils.isNotBlank((CharSequence)e.getSubPart()));
        if (hasSubPart) {
            target.getConstraintColumns().addAll(this.removeSubParts(keyColumns));
        } else {
            target.getConstraintColumns().addAll(keyColumns);
        }
        if (hasSubPart) {
            StringBuilder origin = new StringBuilder();
            origin.append("UNIQUE").append((CharSequence)source.joinConstraintColumns());
            ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, origin + " -> UNIQUE" + target.joinConstraintColumns());
        }
        return target;
    }
}

