/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.obmysql;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Index;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Schema;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xIndex;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;

public abstract class AbstractObMySqlMySqlIndexConverter<S, D>
extends AbstractRuleBasedConverter<S, D> {
    public AbstractObMySqlMySqlIndexConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    protected MySql56Index convertInternal(ObMySql14xIndex source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        MySql56Schema schema = new MySql56Schema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        MySql56Index target = new MySql56Index(schema);
        target.setObjectName(source.getObjectName());
        target.setIndexType(source.getIndexType());
        target.setNonunique(source.getNonunique());
        target.setIndexSchema(source.getIndexSchema());
        target.setIndexName(source.getIndexName());
        target.setIndexComment(source.getIndexComment());
        target.getIndexColumns().addAll(source.getIndexColumns());
        if ("NO".equals(source.getVisible())) {
            if (dbType.isSubsequentFrom(DbType.MYSQL_80)) {
                target.setVisible("NO");
            } else {
                ChangeUtils.info(ObjectType.TABLE, source.getSimpleObjectName(), ChangeInfo.ChangeType.CONVERT, "INVISIBLE INDEX -> VISIBLE INDEX");
            }
        }
        return target;
    }
}

