/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.obmysql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Schema;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56TablePartition;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xTablePartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractObMySqlMySqlPartitionConverter<S, D>
extends AbstractRuleBasedConverter<S, D> {
    private static final Map<String, List<String>> PARTITION_SUBPARTITION_MAP = new HashMap<String, List<String>>();

    public AbstractObMySqlMySqlPartitionConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    protected MySql56TablePartition convertInternal(ObMySql14xTablePartition source) {
        boolean isCompositePartition;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        MySql56Schema schema = new MySql56Schema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        MySql56TablePartition target = new MySql56TablePartition(schema);
        target.setObjectName(source.getObjectName());
        String partitionMethod = source.getPartitionMethod();
        String partitionExpr = source.getPartitionExpression();
        if (StringUtils.isNotBlank((CharSequence)partitionMethod) && !"KEY".equals(partitionMethod) && StringUtils.isBlank((CharSequence)partitionExpr)) {
            ChangeUtils.warn(ObjectType.TABLE, target.getSimpleObjectName(), ChangeInfo.ChangeType.DISCARD, "PARTITION BY " + partitionMethod + "(" + partitionExpr + ") -> [NULL]");
            return null;
        }
        target.setPartitionMethod(partitionMethod);
        target.setPartitionExpression(partitionExpr);
        target.getTablePartitions().addAll(source.getTablePartitions());
        String subPartitionMethod = source.getSubPartitionMethod();
        String subPartitionExpr = source.getSubPartitionExpression();
        boolean bl = isCompositePartition = StringUtils.isNotBlank((CharSequence)subPartitionMethod) && StringUtils.isNotBlank((CharSequence)subPartitionExpr) && source.getPartLevel() > 1;
        if (!isCompositePartition) {
            if (StringUtils.isNotBlank((CharSequence)subPartitionExpr)) {
                ChangeUtils.warn(ObjectType.TABLE, target.getSimpleObjectName(), ChangeInfo.ChangeType.DISCARD, "SUBPARTITION BY " + subPartitionMethod + "(" + subPartitionExpr + ") -> [NULL]");
            }
            return target;
        }
        if (!PARTITION_SUBPARTITION_MAP.containsKey(partitionMethod) || !PARTITION_SUBPARTITION_MAP.get(partitionMethod).contains(subPartitionMethod)) {
            ChangeUtils.warn(ObjectType.TABLE, target.getSimpleObjectName(), ChangeInfo.ChangeType.DISCARD, "SUBPARTITION BY " + subPartitionMethod + "(" + subPartitionExpr + ") -> [NULL]");
            return target;
        }
        target.setSubPartitionMethod(subPartitionMethod);
        target.setSubPartitionExpression(subPartitionExpr);
        target.setSubPartNum(source.getSubPartNum());
        target.getTableSubPartitionMapping().putAll(source.getTableSubPartitionMapping());
        return target;
    }

    static {
        List<String> subpartitions = Arrays.asList("HASH", "KEY");
        PARTITION_SUBPARTITION_MAP.put("RANGE", subpartitions);
        PARTITION_SUBPARTITION_MAP.put("RANGE COLUMNS", subpartitions);
        PARTITION_SUBPARTITION_MAP.put("LIST", subpartitions);
        PARTITION_SUBPARTITION_MAP.put("LIST COLUMNS", subpartitions);
    }
}

