/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.obmysql;

import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.mysql.AbstractMySqlObOracle22xColumnConverter;
import com.oceanbase.obtools.dbdiff.model.adbmysql.AdbMySqlColumn;
import com.oceanbase.obtools.dbdiff.model.adbmysql.AdbMySqlSchema;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xColumn;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@Conversion(sourceDbType=DbType.OBMYSQL_14, targetDbType=DbType.ADB_MYSQL_30)
public class ObMySql14xAdbMySql30ColumnConverter
extends AbstractMySqlObOracle22xColumnConverter<ObMySql14xColumn, AdbMySqlColumn> {
    private static final Map<String, String> MYSQL_ADB30_DATA_TYPE_MAPPING = new HashMap<String, String>();

    public ObMySql14xAdbMySql30ColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public AdbMySqlColumn convertByRule(ObMySql14xColumn source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        AdbMySqlSchema schema = new AdbMySqlSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        AdbMySqlColumn column = new AdbMySqlColumn(schema);
        column.setObjectName(source.getObjectName());
        column.setColumnName(source.getColumnName());
        column.setOrdinalPosition(source.getOrdinalPosition());
        column.setDateTimePrecision(source.getDateTimePrecision());
        column.setExtra(source.getExtra());
        column.setGenerationExpression(source.getGenerationExpression());
        column.setNumericPrecision(source.getNumericPrecision());
        column.setNumericScale(source.getNumericScale());
        column.setColumnComment(source.getColumnComment());
        column.setNullable(source.getNullable());
        column.setCharacterSetName(source.getCharacterSetName());
        column.setCollationName(source.getCollationName());
        column.setColumnDefault(source.getColumnDefault());
        String columnType = source.getColumnType().toLowerCase(Locale.getDefault());
        String dataType = source.getDataType().trim().toUpperCase(Locale.getDefault());
        if (columnType != null && columnType.contains("unsigned") && DbType.ADB_MYSQL_30.equals(dbType)) {
            if ("BIGINT".equals(dataType)) {
                column.setColumnType("decimal(20,0)");
            } else if ("INT".equals(dataType)) {
                column.setColumnType("bigint");
            } else if ("TINYINT".equals(dataType)) {
                column.setColumnType("smallint");
            } else if ("SMALLINT".equals(dataType)) {
                column.setColumnType("int");
            } else if ("MEDIUMINT".equals(dataType)) {
                column.setColumnType("bigint");
            }
        }
        dataType = MYSQL_ADB30_DATA_TYPE_MAPPING.getOrDefault(dataType, dataType);
        column.setDataType(dataType.toLowerCase(Locale.getDefault()));
        return column;
    }

    static {
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("BIGINT", "BIGINT");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("BINARY", "VARBINARY");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("BIT", "VARBINARY");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("BLOB", "VARBINARY");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("CHAR", "VARCHAR");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("DATE", "DATE");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("DATETIME", "DATETIME");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("DECIMAL", "DECIMAL");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("DOUBLE", "DOUBLE");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("ENUM", "VARCHAR");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("FLOAT", "FLOAT");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("GEOMETRY", "VARBINARY");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("GEOMETRYCOLLECTION", "VARBINARY");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("INT", "INT");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("INTEGER", "INT");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("JSON", "JSON");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("LINESTRING", "VARBINARY");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("LONGBLOB", "VARBINARY");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("LONGTEXT", "VARCHAR");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("MEDIUMBLOB", "VARBINARY");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("MEDIUMINT", "INT");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("MEDIUMTEXT", "VARCHAR");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("MULTILINESTRING", "VARBINARY");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("MULTIPOINT", "VARBINARY");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("MULTIPOLYGON", "VARBINARY");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("NUMERIC", "DECIMAL");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("POINT", "VARBINARY");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("POLYGON", "VARBINARY");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("SET", "VARCHAR");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("SMALLINT", "SMALLINT");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("TEXT", "VARCHAR");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("TIME", "TIME");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("TIMESTAMP", "TIMESTAMP");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("TINYBLOB", "VARBINARY");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("TINYINT", "TINYINT");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("TINYTEXT", "VARCHAR");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("VARBINARY", "VARBINARY");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("VARCHAR", "VARCHAR");
        MYSQL_ADB30_DATA_TYPE_MAPPING.put("YEAR", "BIGINT");
    }
}

