/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.obmysql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.constants.JdbcType;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwColumn;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xColumn;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Conversion(sourceDbType=DbType.OBMYSQL_3X, targetDbType=DbType.DB2LUW_1050)
public class ObMySql14xDb2LuwColumnConverter
extends AbstractRuleBasedConverter<ObMySql14xColumn, Db2LuwColumn> {
    public static final int DEFAULT_TIMESTAMP_SCALE = 6;
    protected static final Map<String, String> DATA_TYPES_MAPPING = new HashMap<String, String>();
    protected static final Map<String, String> DEFAULT_MAPPING = new HashMap<String, String>();
    protected static final Set<String> NOT_SUPPORT_DATA_TYPE = new HashSet<String>();
    private static final int FOR_BIT_DATA_FLAG = 0;

    public ObMySql14xDb2LuwColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public Db2LuwColumn convertByRule(ObMySql14xColumn source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        Db2LuwSchema schema = new Db2LuwSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        Db2LuwColumn column = new Db2LuwColumn(schema);
        column.setObjectName(source.getObjectName());
        column.setColumnName(source.getColumnName());
        column.setColumnComment(source.getColumnComment());
        column.setOrdinalPosition(source.getOrdinalPosition());
        String dataType = source.getDataType().toUpperCase(Locale.getDefault());
        String columnType = source.getColumnType();
        Integer dataPrecision = source.getNumericPrecision();
        Integer dataScale = source.getNumericScale();
        Long dataLength = source.getCharacterMaximumLength();
        String objectName = column.getSchemaObjectName();
        StringBuilder sb = new StringBuilder();
        switch (dataType) {
            case "DECIMAL": 
            case "NUMERIC": {
                sb.append(dataType);
                Integer originDataLength = dataPrecision;
                Integer originDataScale = dataScale;
                dataPrecision = Math.min(31, dataPrecision == -1 ? 10 : dataPrecision);
                dataScale = Math.max(0, dataScale);
                if (dataScale > dataPrecision) {
                    dataPrecision = Math.min(31, dataScale);
                    dataScale = Math.min(dataPrecision, dataScale);
                }
                if (originDataLength <= 0 && originDataScale == 0) break;
                sb.append("(").append(dataPrecision);
                if (dataScale != 0) {
                    sb.append(",").append(dataScale);
                }
                sb.append(")");
                break;
            }
            case "DATETIME": 
            case "TIMESTAMP": {
                dataType = "TIMESTAMP";
                sb.append(dataType);
                Integer dateTimePrecision = source.getDateTimePrecision();
                if (dateTimePrecision == null) break;
                if (dateTimePrecision <= 0) {
                    dateTimePrecision = 6;
                }
                if ((dataScale = dateTimePrecision) == 6) break;
                sb.append("(").append(dataScale).append(")");
                break;
            }
            case "CHAR": 
            case "VARCHAR": {
                if ("VARCHAR".equals(dataType)) {
                    dataLength = Math.max(dataLength, 1L);
                }
                column.setStringUnitsLength(dataLength);
                if ("CHAR".equals(dataType) && dataLength > 63L) {
                    dataType = "VARCHAR";
                } else if ("VARCHAR".equals(dataType) && dataLength > 8168L) {
                    dataType = "CLOB";
                }
                sb.append(dataType).append("(").append(dataLength);
                if (DbType.DB2LUW_1050.isPriorFrom(dbType)) {
                    column.setTypeStringUnits("CODEUNITS32");
                    sb.append(" CODEUNITS32");
                }
                sb.append(")");
                break;
            }
            case "BINARY": {
                if (DbType.DB2LUW_1110.isSubsequent(dbType)) {
                    dataType = dataLength < 255L ? "CHAR" : "VARCHAR";
                    column.setCodePage(0);
                    sb.append(dataType).append("(").append(dataLength).append(") FOR BIT DATA");
                    break;
                }
                if (dataLength > 255L) {
                    dataType = "VARBINARY";
                }
                sb.append(dataType).append("(").append(dataLength).append(")");
                break;
            }
            case "VARBINARY": {
                if (DbType.DB2LUW_1110.isSubsequent(dbType)) {
                    dataType = "VARCHAR";
                    column.setCodePage(0);
                    sb.append("VARCHAR").append("(").append(dataLength).append(") FOR BIT DATA");
                } else {
                    sb.append("VARBINARY").append("(").append(dataLength).append(")");
                }
                if (dataLength <= 32672L) break;
                dataType = "BLOB";
                sb.append("BLOB").append("(").append(dataLength).append(")");
                break;
            }
            case "BIT": {
                dataLength = (long)Math.ceil((double)dataPrecision.intValue() / 8.0);
                if (DbType.DB2LUW_1110.isSubsequent(dbType)) {
                    dataType = "CHAR";
                    column.setCodePage(0);
                    sb.append(dataType).append("(").append(dataLength).append(") FOR BIT DATA");
                    break;
                }
                dataType = "BINARY";
                sb.append(dataType).append("(").append(dataLength).append(")");
                break;
            }
            default: {
                if (NOT_SUPPORT_DATA_TYPE.contains(dataType)) {
                    throw new UnsupportedGrammarException(objectName, "The data type: \"" + dataType + "\" is unsupported in " + dbType);
                }
                dataType = DATA_TYPES_MAPPING.getOrDefault(dataType, dataType);
                sb.append(dataType);
            }
        }
        column.setDataType(dataType);
        if (JdbcType.isNumericType(dataType)) {
            column.setDataLength((long)dataPrecision);
        } else {
            column.setDataLength(dataLength);
        }
        column.setDataScale(dataScale);
        column.setNullable(source.getNullable().equals("YES") ? "Y" : "N");
        column.setColumnComment(source.getColumnComment());
        this.resolveDefaultClause(source, column);
        StringBuilder extraInfo = new StringBuilder();
        if ("auto_increment".equalsIgnoreCase(source.getExtra())) {
            extraInfo.append("-- CREATE SEQUENCE xxx START WITH 1 INCREMENT BY 1 ... for ").append(objectName);
        }
        if (!columnType.equalsIgnoreCase(sb.toString())) {
            String detailInfo = source.getWrappedName() + " " + columnType + " -> " + sb.toString();
            if (StringUtils.isBlank((CharSequence)extraInfo)) {
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, detailInfo);
            } else {
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, detailInfo, extraInfo.toString());
            }
        }
        return column;
    }

    protected void resolveDefaultClause(ObMySql14xColumn source, Db2LuwColumn column) {
        String expr;
        DbType originDbType = source.getOriginDbType();
        boolean isObMySql = DbType.OBMYSQL_14.getType().equals(originDbType.getType());
        if (isObMySql && originDbType.isPrior(DbType.OBMYSQL_2250)) {
            ChangeUtils.info(ObjectType.TABLE, column.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, source.getColumnName() + " GENERATED ALWAYS AS ... maybe lost OBMYSQL v2250-");
        }
        if (StringUtils.isNotBlank((CharSequence)(expr = source.getGenerationExpression()))) {
            if ((expr = expr.trim()).startsWith("(") && expr.endsWith(")")) {
                expr = expr.substring(1, expr.length() - 1);
            }
            expr = expr.replaceAll("[`]", "\"");
            column.setGenerated("A");
            column.setText("AS (" + expr + ")");
            return;
        }
        String columnDefault = source.getColumnDefault();
        if (columnDefault == null) {
            return;
        }
        String dataType = source.getDataType();
        if ("BIT".equalsIgnoreCase(dataType)) {
            if (isObMySql && originDbType.isSubsequent(DbType.OBMYSQL_211)) {
                column.setColumnDefault(columnDefault);
            } else {
                ChangeUtils.info(ObjectType.TABLE, column.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, source.getColumnName() + " BIT DEFAULT b'" + columnDefault + "' -> NULL");
                return;
            }
        }
        if ("BLOB".equals(column.getDataType())) {
            if (columnDefault.startsWith("'") && columnDefault.endsWith("'")) {
                columnDefault = "BLOB(" + columnDefault + ")";
            }
        } else if (DEFAULT_MAPPING.containsKey(columnDefault)) {
            columnDefault = DEFAULT_MAPPING.get(columnDefault);
        } else if (!columnDefault.startsWith("'") && !columnDefault.endsWith("'")) {
            columnDefault = "'" + columnDefault + "'";
        }
        column.setColumnDefault(columnDefault);
    }

    static {
        DATA_TYPES_MAPPING.put("INT", "INTEGER");
        DATA_TYPES_MAPPING.put("TINYINT", "SMALLINT");
        DATA_TYPES_MAPPING.put("MEDIUMINT", "BIGINT");
        DATA_TYPES_MAPPING.put("REAL", "DOUBLE");
        DATA_TYPES_MAPPING.put("FLOAT", "DOUBLE");
        DATA_TYPES_MAPPING.put("TINYBLOB", "BLOB");
        DATA_TYPES_MAPPING.put("MEDIUMBLOB", "BLOB");
        DATA_TYPES_MAPPING.put("LONGBLOB", "BLOB");
        DATA_TYPES_MAPPING.put("TEXT", "CLOB");
        DATA_TYPES_MAPPING.put("TINYTEXT", "CLOB");
        DATA_TYPES_MAPPING.put("MEDIUMTEXT", "CLOB");
        DATA_TYPES_MAPPING.put("LONGTEXT", "CLOB");
        DATA_TYPES_MAPPING.put("YEAR", "INTEGER");
        DATA_TYPES_MAPPING.put("JSON", "CLOB");
        DEFAULT_MAPPING.put("current_timestamp", "CURRENT TIMESTAMP");
        DEFAULT_MAPPING.put("CURRENT_TIMESTAMP", "CURRENT TIMESTAMP");
        NOT_SUPPORT_DATA_TYPE.add("ENUM");
        NOT_SUPPORT_DATA_TYPE.add("SET");
    }
}

