/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.obmysql;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.mysql.AbstractSubPartDefinitionClearupConverter;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwIndex;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwIndexPartition;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xIndex;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;

@Conversion(sourceDbType=DbType.OBMYSQL_3X, targetDbType=DbType.DB2LUW_1050)
public class ObMySql14xDb2LuwIndexConverter
extends AbstractSubPartDefinitionClearupConverter<ObMySql14xIndex, Db2LuwIndex> {
    public ObMySql14xDb2LuwIndexConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public Db2LuwIndex convertByRule(ObMySql14xIndex source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        Db2LuwSchema schema = new Db2LuwSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        Db2LuwIndex target = new Db2LuwIndex(schema);
        String indexType = source.getIndexType();
        target.setObjectName(source.getObjectName());
        target.setIndexName(source.getIndexName());
        target.setIndexType(indexType);
        String schemaObjectName = target.getSchemaObjectName();
        if ("UNIQUE".equalsIgnoreCase(indexType) || "GLOBAL UNIQUE".equalsIgnoreCase(indexType)) {
            target.setUniqueness("U");
        } else if ("LOCAL".equalsIgnoreCase(indexType)) {
            Db2LuwIndexPartition indexPartition = new Db2LuwIndexPartition(schema);
            indexPartition.setObjectName(source.getObjectName());
            indexPartition.setLocality("LOCAL");
            target.setTablePartitioned(true);
            target.setIndexPartition(indexPartition);
            ChangeUtils.warn(ObjectType.TABLE, schemaObjectName, ChangeInfo.ChangeType.CONVERT, "create index " + source.getWrappedIndexName() + " ... local -> CREATE INDEX " + target.getWrappedIndexName() + " ... PARTITIONED");
        } else if ("LOCAL UNIQUE".equalsIgnoreCase(indexType)) {
            Db2LuwIndexPartition indexPartition = new Db2LuwIndexPartition(schema);
            indexPartition.setObjectName(source.getObjectName());
            indexPartition.setLocality("LOCAL");
            target.setTablePartitioned(true);
            target.setUniqueness("U");
            target.setIndexPartition(indexPartition);
            ChangeUtils.warn(ObjectType.TABLE, schemaObjectName, ChangeInfo.ChangeType.CONVERT, "create unique index " + source.getWrappedIndexName() + " ... local -> CREATE UNIQUE INDEX " + target.getWrappedIndexName() + " ... PARTITIONED");
        }
        target.getIndexColumns().addAll(source.getIndexColumns());
        return target;
    }
}

