/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.obmysql;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2TablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwTablePartition;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTablePartition;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xTablePartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@Conversion(sourceDbType=DbType.OBMYSQL_3X, targetDbType=DbType.DB2LUW_1050)
public class ObMySql14xDb2LuwPartitionConverter
extends AbstractRuleBasedConverter<ObMySql14xTablePartition, Db2LuwTablePartition> {
    protected static final Set<String> SUPPORTED_PART_TYPES = new HashSet<String>();

    public ObMySql14xDb2LuwPartitionConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public Db2LuwTablePartition convertByRule(ObMySql14xTablePartition source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        String partitionType = source.getPartitionMethod();
        Db2LuwSchema schema = new Db2LuwSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        Db2LuwTablePartition target = new Db2LuwTablePartition(schema);
        target.setObjectName(source.getObjectName());
        target.setPartitionType(partitionType);
        if (SUPPORTED_PART_TYPES.contains(partitionType) && this.isPartitionExprValid(source)) {
            Collection<AbstractDb2TablePartition.Db2TablePartitionColumn> partitionColumns = this.translatePartitionColumns(source);
            target.getPartitionColumns().addAll(partitionColumns);
            target.getPartitionItems().addAll(this.translatePartitionItems(source, partitionColumns.size()));
            int subPartitionKeyCount = source.getSubPartNum();
            String subPartitionType = source.getSubPartitionMethod();
            int partLevel = source.getPartLevel();
            if (subPartitionType != null && subPartitionKeyCount > 0 && partLevel > 1) {
                ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, partitionType + " subpartition of \"" + source.getObjectName() + "\" -> [NULL]");
            }
            return target;
        }
        try {
            source.getSchema().setDbType(source.getOriginDbType());
            ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, source.buildGrammar().toString().trim() + " -> [NULL]");
            source.getSchema().setDbType(dbType);
        }
        catch (UnsupportedGrammarException e) {
            ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, partitionType + " partition of \"" + source.getObjectName() + "\" -> [NULL]");
        }
        return null;
    }

    private Collection<AbstractDb2TablePartition.Db2TablePartitionColumn> translatePartitionColumns(ObMySql14xTablePartition source) {
        ArrayList<AbstractDb2TablePartition.Db2TablePartitionColumn> result = new ArrayList<AbstractDb2TablePartition.Db2TablePartitionColumn>();
        String expr = source.getPartitionExpression();
        if (StringUtils.isBlank((CharSequence)expr)) {
            return result;
        }
        expr = expr.trim().replaceAll("[`\"]", "");
        ArrayList exprs = Lists.newArrayList((Object[])new String[]{expr});
        if (expr.contains(",")) {
            exprs = Lists.newArrayList((Object[])expr.split(","));
        }
        for (int i = 0; i < exprs.size(); ++i) {
            AbstractDb2TablePartition.Db2TablePartitionColumn column = new AbstractDb2TablePartition.Db2TablePartitionColumn();
            column.setName(source.getObjectName());
            expr = (String)exprs.get(i);
            column.setName(expr);
            column.setDataType(null);
            column.setNullsFirst(null);
            column.setPartitionKeySeq(i + 1);
            column.setPartitionExpression(expr);
            column.setPartitionKeyOrdering(null);
            result.add(column);
        }
        return result;
    }

    private Collection<AbstractDb2TablePartition.Db2TablePartitionItem> translatePartitionItems(ObMySql14xTablePartition source, int partKeyCount) {
        ArrayList<AbstractDb2TablePartition.Db2TablePartitionItem> targetPartitionItems = new ArrayList<AbstractDb2TablePartition.Db2TablePartitionItem>();
        Collection<AbstractMySqlTablePartition.MySqlPartitionItem> srcPartitionItems = source.getTablePartitions();
        if (CollectionUtils.isNotEmpty(srcPartitionItems)) {
            String prevHighValue = String.join((CharSequence)",", Collections.nCopies(partKeyCount, "MINVALUE"));
            for (AbstractMySqlTablePartition.MySqlPartitionItem tablePartition : srcPartitionItems) {
                AbstractDb2TablePartition.Db2TablePartitionItem item = new AbstractDb2TablePartition.Db2TablePartitionItem();
                item.setPartitionName(tablePartition.getPartitionName());
                item.setPartitionNumber(tablePartition.getPartitionOrdinalPosition());
                item.setLowValue(prevHighValue);
                item.setLowInclusive("Y");
                prevHighValue = tablePartition.getPartitionDescription();
                item.setHighInclusive("N");
                item.setHighValue(prevHighValue);
                targetPartitionItems.add(item);
            }
        }
        return targetPartitionItems;
    }

    private boolean isPartitionExprValid(ObMySql14xTablePartition partition) {
        String expr = partition.getPartitionExpression();
        Set<String> columnSet = partition.getColumnSet();
        expr = expr.trim().replaceAll("[`\"]", "");
        ArrayList exprs = Lists.newArrayList((Object[])new String[]{expr});
        if (expr.contains(",")) {
            exprs = Lists.newArrayList((Object[])expr.split(","));
        }
        return columnSet.containsAll(exprs);
    }

    static {
        SUPPORTED_PART_TYPES.add("RANGE");
        SUPPORTED_PART_TYPES.add("RANGE COLUMNS");
    }
}

