/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.obmysql;

import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwView;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xView;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.TextUtils;

@Conversion(sourceDbType=DbType.OBMYSQL_3X, targetDbType=DbType.DB2LUW_1050)
public class ObMySql14xDb2LuwViewConverter
extends AbstractRuleBasedConverter<ObMySql14xView, Db2LuwView> {
    public ObMySql14xDb2LuwViewConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public Db2LuwView convertByRule(ObMySql14xView source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        Db2LuwSchema schema = new Db2LuwSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        Db2LuwView target = new Db2LuwView(schema);
        target.setObjectName(source.getObjectName());
        String targetText = TextUtils.replace(source.getText(), source.getSimpleObjectName(), target.getSimpleObjectName());
        targetText = TextUtils.replace(targetText, "`", "\"");
        target.setText(targetText);
        return target;
    }
}

