/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.obmysql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.mysql.AbstractSubPartDefinitionClearupConverter;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xIndex;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xIndex;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xIndexPartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

@Conversion(sourceDbType=DbType.OBMYSQL_14, targetDbType=DbType.OBORACLE_22)
public class ObMySql14xObOracle22xIndexConverter
extends AbstractSubPartDefinitionClearupConverter<ObMySql14xIndex, ObOracle22xIndex> {
    public ObMySql14xObOracle22xIndexConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xIndex convertByRule(ObMySql14xIndex source) {
        ObOracle22xIndexPartition indexPartition;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xIndex target = new ObOracle22xIndex(schema);
        String indexType = source.getIndexType();
        target.setObjectName(source.getObjectName());
        target.setIndexName(source.getIndexName());
        target.setIndexType(indexType);
        if ("UNIQUE".equalsIgnoreCase(indexType)) {
            target.setUniqueness("UNIQUE");
        } else if ("LOCAL".equalsIgnoreCase(indexType)) {
            indexPartition = new ObOracle22xIndexPartition(schema);
            indexPartition.setObjectName(source.getObjectName());
            indexPartition.setLocality("LOCAL");
            target.setIndexPartition(indexPartition);
        } else if ("LOCAL UNIQUE".equalsIgnoreCase(indexType)) {
            indexPartition = new ObOracle22xIndexPartition(schema);
            indexPartition.setObjectName(source.getObjectName());
            indexPartition.setLocality("LOCAL");
            target.setUniqueness("UNIQUE");
            target.setIndexPartition(indexPartition);
        } else if ("GLOBAL".equalsIgnoreCase(indexType)) {
            indexPartition = new ObOracle22xIndexPartition(schema);
            indexPartition.setObjectName(source.getObjectName());
            indexPartition.setLocality("GLOBAL");
            target.setIndexPartition(indexPartition);
        } else if ("GLOBAL UNIQUE".equalsIgnoreCase(indexType)) {
            indexPartition = new ObOracle22xIndexPartition(schema);
            indexPartition.setObjectName(source.getObjectName());
            indexPartition.setLocality("GLOBAL");
            target.setUniqueness("UNIQUE");
            target.setIndexPartition(indexPartition);
        }
        Collection<KeyColumn> keyColumns = source.getIndexColumns().stream().peek(s -> {
            if (s.isExpression()) {
                s.setColumnName(s.getColumnName().replace("`", "\""));
            }
        }).collect(Collectors.toCollection(ArrayList::new));
        boolean isFullTextIndex = "FULLTEXT".equalsIgnoreCase(indexType);
        boolean hasSubPart = keyColumns.stream().anyMatch(e -> StringUtils.isNotBlank((CharSequence)e.getSubPart()));
        target.getIndexColumns().addAll(hasSubPart ? this.removeSubParts(keyColumns) : keyColumns);
        if (isFullTextIndex || hasSubPart) {
            StringBuilder origin = new StringBuilder();
            origin.append("create");
            if (isFullTextIndex) {
                origin.append(" fulltext");
            }
            origin.append(" index ").append(source.getWrappedIndexName());
            origin.append(" on ").append(source.getSchemaObjectName()).append((CharSequence)source.joinIndexColumns());
            String schemaObjectName = target.getSchemaObjectName();
            ChangeUtils.warn(ObjectType.TABLE, schemaObjectName, ChangeInfo.ChangeType.CONVERT, origin + " -> CREATE INDEX " + target.getWrappedIndexName() + " ON " + schemaObjectName + target.joinIndexColumns());
        }
        return target;
    }
}

