/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.obmysql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.mysql.AbstractSubPartDefinitionClearupConverter;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xPrimaryKey;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.List;

@Conversion(sourceDbType=DbType.OBMYSQL_14, targetDbType=DbType.OBORACLE_22)
public class ObMySql14xObOracle22xPrimaryKeyConverter
extends AbstractSubPartDefinitionClearupConverter<ObMySql14xPrimaryKey, ObOracle22xPrimaryKey> {
    public ObMySql14xObOracle22xPrimaryKeyConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xPrimaryKey convertByRule(ObMySql14xPrimaryKey source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xPrimaryKey target = new ObOracle22xPrimaryKey(schema);
        target.setObjectName(source.getObjectName());
        target.setConstraintName(source.getConstraintName());
        List<KeyColumn> keyColumns = source.getConstraintColumns();
        boolean hasSubPart = keyColumns.stream().anyMatch(e -> StringUtils.isNotBlank((CharSequence)e.getSubPart()));
        target.getConstraintColumns().addAll(hasSubPart ? this.removeSubParts(keyColumns) : keyColumns);
        if (hasSubPart) {
            StringBuilder origin = new StringBuilder();
            origin.append("primary key").append((CharSequence)source.joinConstraintColumns());
            ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, origin + " -> PRIMARY KEY" + target.joinConstraintColumns());
        }
        return target;
    }
}

