/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.oboracle;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.oboracle.AbstractObOracleDb2ColumnConverter;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwColumn;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xColumn;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

@Conversion(sourceDbType=DbType.OBORACLE_22, targetDbType=DbType.DB2LUW_1050)
public class ObOracle22xDb2LuwColumnConverter
extends AbstractObOracleDb2ColumnConverter<ObOracle22xColumn, Db2LuwColumn> {
    protected static final Map<String, String> DEFAULT_MAPPING = new HashMap<String, String>();
    private static final int FOR_BIT_DATA_FLAG = 0;
    private static final long DEFAULT_ROWID_LEN = 18L;
    private static final int DEFAULT_PREC_OF_SEC = 0;
    private static final int DEFAULT_LEN_FOR_TZ_SCALE = 9;
    private static final String INTERVAL_YEAR_TO_MON_REG = "(?i)INTERVAL\\s+YEAR\\(?\\d+\\)?\\s+TO\\s+MONTH";
    private static final String INTERVAL_DAY_TO_SEC_REG = "(?i)INTERVAL\\s+DAY\\(?\\d+\\)?\\s+TO\\s+SECOND\\(?\\d+\\)?";
    private static final String TMS_REG = "(?i)TIMESTAMP\\s*\\(?\\d+\\)?";
    private static final String TMS_WITH_TZ_REG = "(?i)TIMESTAMP\\s*\\(?\\d+\\)?\\s+WITH\\s+TIME\\s+ZONE";
    private static final String TMS_WITH_LTZ_REG = "(?i)TIMESTAMP\\s*\\(?\\d+\\)?\\s+WITH\\s+LOCAL\\s+TIME\\s+ZONE";

    public ObOracle22xDb2LuwColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public Db2LuwColumn convertByRule(ObOracle22xColumn source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        Db2LuwSchema schema = new Db2LuwSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        String dataType = source.getDataType();
        Long dataLength = source.getDataLength();
        Long charLength = source.getCharLength();
        Integer dataScale = source.getDataScale();
        Integer dataPrecision = source.getDataPrecision();
        String originDataType = dataType;
        Db2LuwColumn target = new Db2LuwColumn(schema);
        target.setObjectName(source.getObjectName());
        target.setColumnName(source.getColumnName());
        if ("YES".equals(source.getHiddenColumn())) {
            target.setHidden("I");
        }
        String objectName = source.getSchemaObjectName();
        String wrappedName = source.getWrappedName();
        switch (dataType) {
            case "RAW": {
                dataType = "VARCHAR";
                target.setCodePage(0);
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, wrappedName + " RAW(" + dataLength + ") -> VARCHAR(" + dataLength + ") FOR BIT DATA");
                break;
            }
            case "ROWID": {
                dataType = "CHAR";
                dataLength = 18L;
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, wrappedName + " ROWID(" + dataLength + ") -> VARCHAR(" + dataLength + ")");
                break;
            }
            case "UROWID": {
                dataType = "VARCHAR";
                dataLength = 18L;
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, wrappedName + " UROWID(" + dataLength + ") -> VARCHAR(" + dataLength + ")");
                break;
            }
            case "DATE": {
                dataType = "TIMESTAMP";
                dataScale = 0;
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, wrappedName + " DATE -> TIMESTAMP(" + dataScale + ")");
                break;
            }
            case "NCHAR": {
                if (charLength > 254L) {
                    dataType = "NVARCHAR";
                    dataLength = Math.min(8168L, charLength);
                    ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, wrappedName + " NCHAR(" + charLength + ") -> NVARCHAR(" + dataLength + ")");
                    break;
                }
                dataLength = Math.min(63L, charLength);
                break;
            }
            case "NVARCHAR2": {
                if (charLength < 8169L) {
                    dataType = "NVARCHAR";
                    dataLength = Math.min(8168L, charLength);
                    break;
                }
                dataType = "NCLOB";
                dataLength = Math.min(0x1FFFFFFFL, charLength);
                break;
            }
            case "CHAR": 
            case "VARCHAR": 
            case "VARCHAR2": {
                boolean isCharUsed = "C".equals(source.getCharUsed());
                if (DbType.DB2LUW_1010.isPriorFrom(dbType) && DbType.DB2LUW_1050.isSubsequent(dbType)) {
                    charLength = isCharUsed ? charLength * 4L : charLength;
                }
                target.setStringUnitsLength(charLength);
                if (DbType.DB2LUW_1050.isPriorFrom(dbType)) {
                    target.setTypeStringUnits(isCharUsed ? "CODEUNITS32" : "OCTETS");
                }
                if ("CHAR".equals(dataType)) {
                    if (isCharUsed && target.getStringUnitsLength() > 63L) {
                        target.setStringUnitsLength(63L);
                    }
                    if (!isCharUsed && target.getStringUnitsLength() > 254L) {
                        target.setStringUnitsLength(254L);
                    }
                }
                String changedInfo = wrappedName + " " + originDataType + "(" + (isCharUsed ? charLength : dataLength);
                changedInfo = changedInfo + " " + (isCharUsed ? "CHAR" : "BYTE") + ") -> ";
                changedInfo = changedInfo + DEFAULT_COLUMN_MAPPING.getOrDefault(dataType, dataType);
                changedInfo = changedInfo + "(" + target.getStringUnitsLength();
                if (DbType.DB2LUW_1050.isPriorFrom(dbType)) {
                    changedInfo = changedInfo + " " + target.getTypeStringUnits();
                }
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, changedInfo + ")");
                break;
            }
            case "FLOAT": {
                dataType = dataPrecision > 63 ? "DOUBLE" : dataType;
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, wrappedName + " " + originDataType + (dataPrecision > 0 ? "(" + dataPrecision + ")" : "") + " -> " + dataType);
                break;
            }
            case "NUMBER": {
                dataType = "NUMERIC";
                Long originDataLength = dataLength = Long.valueOf(dataPrecision.intValue());
                Integer originDataScale = dataScale;
                dataLength = Math.min(31L, dataLength == -1L ? 38L : dataLength);
                dataScale = Math.max(0, dataScale);
                if ((long)dataScale.intValue() > dataLength) {
                    dataLength = Math.min(31L, (long)dataScale.intValue());
                    dataScale = (int)Math.min(dataLength, (long)dataScale.intValue());
                }
                StringBuilder prevDesc = new StringBuilder(originDataType);
                if (originDataLength > 0L) {
                    prevDesc.append("(").append(originDataLength);
                    if (originDataScale != 0) {
                        prevDesc.append(",").append(originDataScale);
                    }
                    prevDesc.append(")");
                }
                StringBuilder postDesc = new StringBuilder(dataType);
                if (originDataLength > 19L || originDataScale != 0) {
                    postDesc.append("(").append(dataLength);
                    if (dataScale != 0) {
                        postDesc.append(",").append(dataScale);
                    }
                    postDesc.append(")");
                }
                ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, wrappedName + " " + prevDesc + " -> " + postDesc);
                break;
            }
            default: {
                String targetString;
                StringTokenizer st;
                if (dataType.matches(TMS_REG)) {
                    String len = "0";
                    String temp = dataType.replace(" ", "");
                    if (temp.contains("(") && temp.contains(")")) {
                        len = temp.substring(temp.indexOf(40) + 1, temp.indexOf(41));
                    }
                    dataType = "TIMESTAMP";
                    dataScale = Integer.parseInt(len);
                } else if (dataType.matches(TMS_WITH_TZ_REG) || dataType.matches(TMS_WITH_LTZ_REG)) {
                    dataType = "TIMESTAMP";
                } else if (dataType.matches(INTERVAL_YEAR_TO_MON_REG)) {
                    long prec = 4L;
                    st = new StringTokenizer(dataType, " ");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if (!token.contains("(") || !token.contains(")")) continue;
                        prec += Long.parseLong(token = token.substring(token.indexOf(40) + 1, token.indexOf(41))) != 0L ? Long.parseLong(token) : 4L;
                    }
                    dataType = "VARCHAR";
                    dataLength = prec;
                } else if (dataType.matches(INTERVAL_DAY_TO_SEC_REG)) {
                    long prec = 11L;
                    st = new StringTokenizer(dataType, " ");
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if (!token.contains("(") || !token.contains(")")) continue;
                        prec += Long.parseLong(token = token.substring(token.indexOf(40) + 1, token.indexOf(41))) != 0L ? Long.parseLong(token) : 2L;
                    }
                    dataType = "VARCHAR";
                    dataLength = prec;
                }
                dataType = DEFAULT_COLUMN_MAPPING.getOrDefault(dataType, dataType);
                Long newLength = dataLength == 0L ? (long)Math.max(0, dataScale) : dataLength;
                String originString = originDataType;
                if (!originDataType.matches(INTERVAL_YEAR_TO_MON_REG) && !originDataType.matches(INTERVAL_DAY_TO_SEC_REG)) {
                    originString = originString + (dataLength > 0L ? "(" + dataLength + ")" : "");
                }
                if (!StringUtils.notEquals((CharSequence)originString, (CharSequence)(targetString = dataType + (newLength >= 0L ? "(" + newLength + ")" : "")))) break;
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, wrappedName + " " + originString + " -> " + targetString);
                break;
            }
        }
        target.setDataType(DEFAULT_COLUMN_MAPPING.getOrDefault(dataType, dataType));
        target.setDataLength(dataLength);
        target.setDataScale(dataScale);
        target.setNullable(source.getNullable());
        target.setColumnComment(source.getColumnComment());
        String columnDefault = source.getColumnDefault();
        if (columnDefault != null) {
            if ("YES".equals(source.getVirtualColumn())) {
                target.setGenerated("A");
                target.setText("AS (" + columnDefault + ")");
            } else {
                if (!DEFAULT_MAPPING.containsKey(columnDefault = DEFAULT_MAPPING.getOrDefault(columnDefault, columnDefault))) {
                    if ("BLOB".equals(target.getDataType())) {
                        if (columnDefault.startsWith("'") && columnDefault.endsWith("'")) {
                            columnDefault = "BLOB(" + columnDefault + ")";
                        }
                    } else if ("CLOB".equals(target.getDataType()) && !columnDefault.startsWith("'") && !columnDefault.endsWith("'")) {
                        columnDefault = "'" + columnDefault + "'";
                    }
                }
                target.setColumnDefault(columnDefault);
            }
        }
        return target;
    }

    static {
        DEFAULT_MAPPING.put("sysdate", "CURRENT TIMESTAMP");
        DEFAULT_MAPPING.put("SYSDATE", "CURRENT TIMESTAMP");
        DEFAULT_MAPPING.put("systimestamp", "CURRENT TIMESTAMP");
        DEFAULT_MAPPING.put("SYSTIMESTAMP", "CURRENT TIMESTAMP");
        DEFAULT_MAPPING.put("current_date", "CURRENT TIMESTAMP");
        DEFAULT_MAPPING.put("CURRENT_DATE", "CURRENT TIMESTAMP");
        DEFAULT_MAPPING.put("current_timestamp", "CURRENT TIMESTAMP");
        DEFAULT_MAPPING.put("CURRENT_TIMESTAMP", "CURRENT TIMESTAMP");
        DEFAULT_MAPPING.put("empty_clob()", "empty_clob()");
        DEFAULT_MAPPING.put("EMPTY_CLOB()", "EMPTY_CLOB()");
        DEFAULT_MAPPING.put("empty_blob()", "empty_blob()");
        DEFAULT_MAPPING.put("EMPTY_BLOB()", "EMPTY_BLOB()");
    }
}

