/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.oboracle;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLTimestampExpr;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.db2.AbstractDb2TablePartition;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwSchema;
import com.oceanbase.obtools.dbdiff.model.db2.luw.Db2LuwTablePartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTablePartition;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

@Conversion(sourceDbType=DbType.OBORACLE_22, targetDbType=DbType.DB2LUW_1050)
public class ObOracle22xDb2LuwPartitionConverter
extends AbstractRuleBasedConverter<ObOracle22xTablePartition, Db2LuwTablePartition> {
    private static final Set<String> METHODS = new HashSet<String>();

    public ObOracle22xDb2LuwPartitionConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    private static void extract0(List<String> values, SQLExpr expr) {
        if (expr instanceof SQLListExpr) {
            List items = ((SQLListExpr)expr).getItems();
            for (SQLExpr item : items) {
                ObOracle22xDb2LuwPartitionConverter.extract0(values, item);
            }
        }
        if (expr instanceof SQLCharExpr) {
            values.add("'" + ((SQLCharExpr)expr).getValue().toString().trim() + "'");
        } else if (expr instanceof SQLIntegerExpr) {
            values.add(String.valueOf(((SQLIntegerExpr)expr).getValue()));
        } else if (expr instanceof SQLNumberExpr) {
            values.add(String.valueOf(((SQLNumberExpr)expr).getValue()));
        } else if (expr instanceof SQLTimestampExpr) {
            values.add("'" + ((SQLTimestampExpr)expr).getValue() + "'");
        } else if (expr instanceof SQLIdentifierExpr) {
            values.add(String.valueOf(((SQLIdentifierExpr)expr).getName()));
        } else if (expr instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr invoker = (SQLMethodInvokeExpr)expr;
            String method = invoker.getMethodName();
            List args = invoker.getArguments();
            if (args != null) {
                if (METHODS.contains(method.toLowerCase(Locale.getDefault()))) {
                    ObOracle22xDb2LuwPartitionConverter.extract0(values, (SQLExpr)args.get(0));
                } else {
                    for (SQLExpr arg : args) {
                        ObOracle22xDb2LuwPartitionConverter.extract0(values, arg);
                    }
                }
            }
        }
    }

    @Override
    public Db2LuwTablePartition convertByRule(ObOracle22xTablePartition source) {
        String partitionType = source.getPartitioningType();
        if ("RANGE".equals(partitionType)) {
            Global global = source.getGlobal();
            DbType dbType = source.getDbType();
            String schemaName = source.getSchemaName();
            Db2LuwSchema schema = new Db2LuwSchema(global, dbType, schemaName);
            schema.setOriginDbType(source.getOriginDbType());
            Db2LuwTablePartition target = new Db2LuwTablePartition(schema);
            target.setObjectName(source.getObjectName());
            target.setPartitionType(partitionType);
            target.getPartitionColumns().addAll(this.translatePartitionColumns(source));
            target.getPartitionItems().addAll(this.translatePartitionItems(source));
            Integer subPartitionKeyCount = source.getSubPartitioningKeyCount();
            Integer defSubPartitionCount = source.getDefSubPartitionCount();
            String subPartitionType = source.getSubPartitioningType();
            if (subPartitionType != null && subPartitionKeyCount > 0 && defSubPartitionCount > 0) {
                ChangeUtils.warn(ObjectType.TABLE, source.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, partitionType + " subpartition of \"" + source.getObjectName() + "\" -> [NULL]");
            }
            return target;
        }
        try {
            DbType dbType = source.getDbType();
            source.getSchema().setDbType(source.getOriginDbType());
            ChangeUtils.warn(ObjectType.TABLE, source.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, source.buildGrammar().toString().trim() + " -> [NULL]");
            source.getSchema().setDbType(dbType);
        }
        catch (UnsupportedGrammarException e) {
            ChangeUtils.warn(ObjectType.TABLE, source.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, partitionType + " partition of \"" + source.getObjectName() + "\" -> [NULL]");
        }
        return null;
    }

    private Collection<AbstractDb2TablePartition.Db2TablePartitionItem> translatePartitionItems(ObOracle22xTablePartition source) {
        ArrayList<AbstractDb2TablePartition.Db2TablePartitionItem> targetTablePartitions = new ArrayList<AbstractDb2TablePartition.Db2TablePartitionItem>();
        Collection<AbstractOracleTablePartition.OracleTablePartitionItem> tablePartitions = source.getTablePartitions();
        if (CollectionUtils.isNotEmpty(tablePartitions)) {
            String prevHighValue;
            int keys = source.getPartitioningKeyCount();
            String prevExpr = prevHighValue = String.join((CharSequence)",", Collections.nCopies(keys, "MINVALUE"));
            for (AbstractOracleTablePartition.OracleTablePartitionItem tablePartition : tablePartitions) {
                AbstractDb2TablePartition.Db2TablePartitionItem item = new AbstractDb2TablePartition.Db2TablePartitionItem();
                item.setPartitionName(tablePartition.getPartitionName());
                item.setPartitionNumber(tablePartition.getPartitionPosition());
                item.setLowValue(prevHighValue);
                if (prevExpr.contains("MINVALUE") || this.isHighValueDateExpr(prevExpr)) {
                    item.setLowInclusive("Y");
                } else {
                    item.setLowInclusive("N");
                }
                prevHighValue = this.doSimpleParse(tablePartition.getHighValue()).trim();
                prevExpr = tablePartition.getHighValue();
                if (this.isHighValueDateExpr(prevExpr)) {
                    item.setHighInclusive("N");
                } else {
                    item.setHighInclusive("Y");
                }
                item.setHighValue(prevHighValue);
                targetTablePartitions.add(item);
            }
        }
        return targetTablePartitions;
    }

    private String doSimpleParse(String highValue) {
        ArrayList<String> values = new ArrayList<String>();
        SQLExpr expr = SQLUtils.toSQLExpr((String)("(" + highValue + ")"));
        ObOracle22xDb2LuwPartitionConverter.extract0(values, expr);
        return String.join((CharSequence)",", values);
    }

    private boolean isHighValueDateExpr(String highValue) {
        SQLExpr expr = SQLUtils.toSQLExpr((String)("(" + highValue + ")"));
        if (expr instanceof SQLMethodInvokeExpr) {
            SQLMethodInvokeExpr invoker = (SQLMethodInvokeExpr)expr;
            String method = invoker.getMethodName();
            return "to_date".equalsIgnoreCase(method);
        }
        return false;
    }

    private Collection<AbstractDb2TablePartition.Db2TablePartitionColumn> translatePartitionColumns(ObOracle22xTablePartition source) {
        ArrayList<AbstractDb2TablePartition.Db2TablePartitionColumn> result = new ArrayList<AbstractDb2TablePartition.Db2TablePartitionColumn>();
        Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> partitionColumns = source.getTablePartitionColumns();
        if (CollectionUtils.isNotEmpty(partitionColumns)) {
            for (AbstractOracleTablePartition.OracleTablePartitionColumn partitionColumn : partitionColumns) {
                AbstractDb2TablePartition.Db2TablePartitionColumn column = new AbstractDb2TablePartition.Db2TablePartitionColumn();
                column.setName(partitionColumn.getName());
                column.setDataType(null);
                column.setNullsFirst(null);
                column.setPartitionKeySeq(partitionColumn.getColumnPosition());
                column.setPartitionExpression(partitionColumn.getColumnName());
                column.setPartitionKeyOrdering(null);
                result.add(column);
            }
        }
        return result;
    }

    static {
        METHODS.add("to_date");
        METHODS.add("to_char");
    }
}

