/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.oboracle;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.constants.JdbcType;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Column;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Schema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xColumn;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.HashMap;
import java.util.Map;

@Conversion(sourceDbType=DbType.OBORACLE_22, targetDbType=DbType.MYSQL_56)
public class ObOracle22xMySql56ColumnConverter
extends AbstractRuleBasedConverter<ObOracle22xColumn, MySql56Column> {
    private static final long DEFAULT_ROWID_LEN = 18L;
    private static final Map<String, String> COLUMN_TYPE_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> BUILTIN_FUNC_MAPPING = new HashMap<String, String>();

    public ObOracle22xMySql56ColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public MySql56Column convertByRule(ObOracle22xColumn source) {
        String columnType = "";
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        MySql56Schema schema = new MySql56Schema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        MySql56Column target = new MySql56Column(schema);
        target.setObjectName(source.getObjectName());
        target.setColumnName(source.getColumnName());
        String objectName = target.getSimpleObjectName();
        Long dataLength = source.getDataLength();
        String dataType = source.getDataType();
        String columnDefault = source.getColumnDefault();
        String originDataType = dataType;
        StringBuilder sb = new StringBuilder();
        String wrappedName = source.getWrappedName();
        switch (dataType) {
            case "DATE": 
            case "CLOB": 
            case "BLOB": 
            case "NCLOB": 
            case "FLOAT": 
            case "BINARY_FLOAT": 
            case "BINARY_DOUBLE": {
                break;
            }
            case "ROWID": {
                dataType = "CHAR";
                dataLength = 18L;
                sb.append("(").append(dataLength).append(")");
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, wrappedName + " ROWID(" + dataLength + ") -> VARCHAR(" + dataLength + ")");
                break;
            }
            case "UROWID": {
                dataType = "VARCHAR";
                dataLength = 18L;
                sb.append("(").append(dataLength).append(")");
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, wrappedName + " UROWID(" + dataLength + ") -> VARCHAR(" + dataLength + ")");
                break;
            }
            case "NUMBER": {
                Integer dataPrecision = source.getDataPrecision();
                Integer dataScale = source.getDataScale();
                if (dataPrecision != null && dataPrecision > 0) {
                    sb.append("(").append(dataPrecision);
                    if (dataScale != null && dataScale > 0) {
                        sb.append(", ").append(Math.min(30, Math.min(dataPrecision, dataScale)));
                    } else if (dataScale != null && dataScale == 0) {
                        if (dataPrecision <= 11) {
                            dataType = "INT";
                        }
                        if (dataLength > 11L && dataLength <= 19L) {
                            dataType = "BIGINT";
                        }
                    }
                    sb.append(")");
                    break;
                }
                if (dataPrecision != null && dataScale == 0) {
                    sb.append("(38, 0)");
                    break;
                }
                sb.append("(65, 30)");
                break;
            }
            default: {
                if (dataType.startsWith("TIMESTAMP") || dataType.startsWith("INTERVAL")) break;
                String charUsed = source.getCharUsed();
                if ("B".equals(charUsed)) {
                    Long charLength = source.getCharLength();
                    if ("CHAR".equals(dataType) && charLength > 256L) {
                        dataType = "VARCHAR";
                        ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, wrappedName + " " + originDataType + " -> " + dataType);
                    }
                    sb.append("(").append(source.getCharLength()).append(")");
                    break;
                }
                if ("C".equals(charUsed)) {
                    if ("CHAR".equals(dataType) || "NCHAR".equals(dataType)) {
                        dataType = "VARCHAR";
                    }
                    sb.append("(").append(source.getCharLength()).append(")");
                    break;
                }
                if (dataLength == null || dataLength <= 0L) break;
                sb.append("(").append(dataLength).append(")");
            }
        }
        if (dataType.startsWith("INTERVAL") || dataType.startsWith("TIMESTAMP")) {
            int dataScale = Math.min(source.getDataScale(), 6);
            if (dataType.endsWith("LOCAL TIME ZONE")) {
                dataType = "TIMESTAMP";
                columnType = "TIMESTAMP(" + dataScale + ")";
            } else if (dataType.endsWith("TIME ZONE")) {
                dataType = "VARCHAR";
                columnType = "VARCHAR(50)";
            } else if (dataType.startsWith("TIMESTAMP")) {
                dataType = "DATETIME";
                columnType = "DATETIME(" + dataScale + ")";
            } else {
                dataType = "VARCHAR";
                columnType = "VARCHAR(50)";
            }
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, wrappedName + " " + originDataType + " -> " + columnType);
        } else {
            dataType = COLUMN_TYPE_MAPPING.getOrDefault(dataType, dataType);
            StringBuilder typeLength = new StringBuilder();
            typeLength.append(dataType).append((CharSequence)sb);
            if ("CHAR".equals(dataType) || "VARCHAR".equals(dataType)) {
                typeLength.append(" binary");
            }
            columnType = typeLength.toString();
            if (COLUMN_TYPE_MAPPING.containsKey(originDataType)) {
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, wrappedName + " " + originDataType + " -> " + columnType);
            }
        }
        target.setColumnType(columnType);
        if (columnDefault != null && !"null".equals(columnDefault.trim())) {
            String originColumnDefault = columnDefault;
            columnDefault = columnDefault.trim();
            if ("YES".equals(source.getVirtualColumn())) {
                target.setGenerationExpression(columnDefault.replace(source.getQuotaCharacter(), target.getQuotaCharacter()));
                if (!originColumnDefault.equals(target.getGenerationExpression())) {
                    ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, "The generation expression: " + originColumnDefault + " -> " + target.getGenerationExpression());
                }
            } else {
                boolean isEnclose;
                if (columnDefault.startsWith("TO_TIMESTAMP") || columnDefault.startsWith("TIMESTAMP") || columnDefault.startsWith("DATE")) {
                    columnDefault = "'" + StringUtils.substringFirstScope((String)columnDefault, (String)"'") + "'";
                    ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, "The column default: " + originColumnDefault + " -> " + columnDefault);
                }
                boolean bl = isEnclose = columnDefault.startsWith("('") && columnDefault.endsWith("')");
                if (isEnclose) {
                    columnDefault = columnDefault.substring(1, columnDefault.length() - 1);
                }
                if (originDataType.startsWith("INTERVAL") && columnDefault.startsWith("interval")) {
                    columnDefault = columnDefault.substring(columnDefault.indexOf(39), columnDefault.lastIndexOf(39) + 1);
                    ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, "The column default: " + originColumnDefault + " -> " + columnDefault);
                }
                if (JdbcType.isNoDefaultValueType(dataType)) {
                    columnDefault = null;
                    ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, target.getColumnName() + " default " + originColumnDefault + " -> " + source.getColumnDefault());
                }
                if (JdbcType.isNumericType(dataType) && columnDefault.contains("NEXTVAL")) {
                    columnDefault = null;
                    ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, source.getWrappedName() + " default " + source.getColumnDefault() + " -> [NULL]");
                }
                target.setColumnDefault(BUILTIN_FUNC_MAPPING.getOrDefault(columnDefault, columnDefault));
                target.setDefaultUdt(!StringUtils.isNotBlank((CharSequence)columnDefault) || !columnDefault.startsWith("'") || !columnDefault.endsWith("'"));
                if (BUILTIN_FUNC_MAPPING.containsKey(columnDefault)) {
                    ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, target.getColumnName() + " default " + originColumnDefault + " -> " + target.getColumnDefault());
                }
            }
        }
        if ("N".equals(source.getNullable())) {
            target.setNullable("NO");
        }
        if ("YES".equals(source.getHiddenColumn())) {
            target.setExtra("INVISIBLE");
        }
        target.setDataType(dataType);
        target.setColumnComment(source.getColumnComment());
        target.setOrdinalPosition(source.getOrdinalPosition());
        return target;
    }

    protected void resolveDefaultClause(ObOracle22xColumn source, ObOracle22xColumn column) {
    }

    static {
        COLUMN_TYPE_MAPPING.put("VARCHAR2", "VARCHAR");
        COLUMN_TYPE_MAPPING.put("NVARCHAR2", "VARCHAR");
        COLUMN_TYPE_MAPPING.put("NUMBER", "NUMERIC");
        COLUMN_TYPE_MAPPING.put("RAW", "VARBINARY");
        COLUMN_TYPE_MAPPING.put("CLOB", "LONGTEXT");
        COLUMN_TYPE_MAPPING.put("NCLOB", "LONGTEXT");
        COLUMN_TYPE_MAPPING.put("BLOB", "LONGBLOB");
        COLUMN_TYPE_MAPPING.put("FLOAT", "DOUBLE");
        COLUMN_TYPE_MAPPING.put("BINARY_FLOAT", "DOUBLE");
        COLUMN_TYPE_MAPPING.put("BINARY_DOUBLE", "DOUBLE");
        COLUMN_TYPE_MAPPING.put("DATE", "DATETIME");
        BUILTIN_FUNC_MAPPING.put("SYSDATE", "CURRENT_TIMESTAMP");
        BUILTIN_FUNC_MAPPING.put("sysdate", "CURRENT_TIMESTAMP");
        BUILTIN_FUNC_MAPPING.put("CURRENT_DATE", "CURRENT_TIMESTAMP");
        BUILTIN_FUNC_MAPPING.put("current_date", "CURRENT_TIMESTAMP");
    }
}

