/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.oboracle;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Index;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Schema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xIndex;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.List;

@Conversion(sourceDbType=DbType.OBORACLE_22, targetDbType=DbType.MYSQL_56)
public class ObOracle22xMySql56IndexConverter
extends AbstractRuleBasedConverter<ObOracle22xIndex, MySql56Index> {
    public ObOracle22xMySql56IndexConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public MySql56Index convertByRule(ObOracle22xIndex source) {
        String visibility;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        MySql56Schema schema = new MySql56Schema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        MySql56Index target = new MySql56Index(schema);
        target.setObjectName(source.getObjectName());
        String uniqueness = source.getUniqueness();
        if (StringUtils.isNotBlank((CharSequence)uniqueness)) {
            if ("UNIQUE".equalsIgnoreCase(uniqueness)) {
                target.setNonunique(0);
                target.setIndexType("UNIQUE");
            } else {
                target.setNonunique(1);
            }
        }
        if ("INVISIBLE".equals(visibility = source.getVisibility())) {
            if (dbType.isSubsequentFrom(DbType.MYSQL_80)) {
                target.setVisible("NO");
            } else {
                ChangeUtils.info(ObjectType.TABLE, source.getSimpleObjectName(), ChangeInfo.ChangeType.CONVERT, "INVISIBLE INDEX -> VISIBLE INDEX");
            }
        }
        target.setIndexSchema(source.getIndexSchema());
        target.setIndexName(source.getIndexName());
        String objectName = target.getSimpleObjectName();
        List<KeyColumn> indexColumns = source.getIndexColumns();
        for (KeyColumn indexColumn : indexColumns) {
            String columnName = indexColumn.getColumnName();
            String columnOrder = indexColumn.getColumnOrder();
            if ("DESC".equals(columnOrder)) {
                indexColumn.setColumnOrder("ASC");
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, columnName + " " + columnOrder + " -> " + columnName + " " + "ASC");
            }
            if (indexColumn.isExpression()) {
                indexColumn.setColumnName(columnName.replace('\"', '`'));
            }
            target.getIndexColumns().add(indexColumn);
        }
        return target;
    }
}

