/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.oboracle;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTablePartition;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Schema;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56TablePartition;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTablePartition;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Conversion(sourceDbType=DbType.OBORACLE_22, targetDbType=DbType.MYSQL_56)
public class ObOracle22xMySql56PartitionConverter
extends AbstractRuleBasedConverter<ObOracle22xTablePartition, MySql56TablePartition> {
    private static final Map<String, List<String>> PARTITION_SUBPARTITION_MAP = new HashMap<String, List<String>>();
    private static final Map<String, String> PARTITION_TYPE_MAP = new HashMap<String, String>();

    public ObOracle22xMySql56PartitionConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public MySql56TablePartition convertByRule(ObOracle22xTablePartition source) {
        String subPartitionType;
        String partitionType;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        MySql56Schema schema = new MySql56Schema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        MySql56TablePartition target = new MySql56TablePartition(schema);
        target.setObjectName(source.getObjectName());
        boolean isComposite = source.isComposite();
        String objectName = target.getSimpleObjectName();
        String originPartitionType = partitionType = source.getPartitioningType();
        partitionType = PARTITION_TYPE_MAP.getOrDefault(partitionType, partitionType);
        if (PARTITION_TYPE_MAP.containsKey(originPartitionType)) {
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, "PARTITION BY " + originPartitionType + " -> PARTITION BY " + partitionType);
        }
        String partitionExpression = source.getTablePartitionColumns().stream().map(e -> "`" + e.getColumnName() + "`").collect(Collectors.joining(","));
        target.setPartitionMethod(partitionType);
        target.setPartitionExpression(partitionExpression);
        Collection<AbstractOracleTablePartition.OracleTablePartitionItem> tablePartitions = source.getTablePartitions();
        for (AbstractOracleTablePartition.OracleTablePartitionItem sourceItem : tablePartitions) {
            AbstractMySqlTablePartition.MySqlPartitionItem targetItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
            targetItem.setPartitionName(sourceItem.getPartitionName());
            targetItem.setPartitionOrdinalPosition(sourceItem.getPartitionPosition());
            targetItem.setPartitionDescription(sourceItem.getHighValue());
            target.getTablePartitions().add(targetItem);
        }
        if (!isComposite) {
            return target;
        }
        String originSubPartitionType = subPartitionType = source.getSubPartitioningType();
        subPartitionType = PARTITION_TYPE_MAP.getOrDefault(subPartitionType, subPartitionType);
        Iterator<AbstractOracleTablePartition.OracleTablePartitionItem> iter = tablePartitions.iterator();
        Map<String, List<AbstractOracleTablePartition.OracleTablePartitionItem>> tableSubPartitionMapping = source.getTableSubPartitionMapping();
        boolean isHasSubPartitions = MapUtils.isNotEmpty(tableSubPartitionMapping);
        while (isHasSubPartitions && iter.hasNext()) {
            AbstractOracleTablePartition.OracleTablePartitionItem partItem = iter.next();
            String partName = partItem.getPartitionName();
            List<AbstractOracleTablePartition.OracleTablePartitionItem> subPartItems = tableSubPartitionMapping.get(partName);
            if (!CollectionUtils.isNotEmpty(subPartItems)) continue;
            ArrayList<AbstractMySqlTablePartition.MySqlPartitionItem> subPartitionItems = new ArrayList<AbstractMySqlTablePartition.MySqlPartitionItem>();
            for (AbstractOracleTablePartition.OracleTablePartitionItem subPartItem : subPartItems) {
                AbstractMySqlTablePartition.MySqlPartitionItem targetItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
                targetItem.setPartitionName(subPartItem.getSubPartitionName());
                targetItem.setSubPartitionName(subPartItem.getSubPartitionName());
                targetItem.setPartitionOrdinalPosition(subPartItem.getPartitionPosition());
                targetItem.setPartitionDescription(subPartItem.getHighValue());
                subPartitionItems.add(targetItem);
            }
            String partId = String.valueOf(partItem.getPartitionPosition());
            target.getTableSubPartitionMapping().put(partId, subPartitionItems);
        }
        Collection<AbstractOracleTablePartition.OracleTablePartitionTemplate> partitionTemplates = source.getTablePartitionTemplates();
        if (CollectionUtils.isNotEmpty(partitionTemplates)) {
            for (AbstractOracleTablePartition.OracleTablePartitionItem sourceItem : tablePartitions) {
                String partitionName = sourceItem.getPartitionName();
                ArrayList<AbstractMySqlTablePartition.MySqlPartitionItem> subPartitionItems = new ArrayList<AbstractMySqlTablePartition.MySqlPartitionItem>();
                for (AbstractOracleTablePartition.OracleTablePartitionTemplate partitionTemplate : partitionTemplates) {
                    AbstractMySqlTablePartition.MySqlPartitionItem targetItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
                    targetItem.setPartitionName(partitionName);
                    targetItem.setSubPartitionName(partitionTemplate.getSubPartitionName());
                    targetItem.setPartitionOrdinalPosition(partitionTemplate.getSubPartitionPosition());
                    targetItem.setPartitionDescription(partitionTemplate.getHighBound());
                    subPartitionItems.add(targetItem);
                }
                target.getTableSubPartitionMapping().putIfAbsent(String.valueOf(-1), subPartitionItems);
            }
            if (DbType.OBMYSQL_2271.isPrior(dbType)) {
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, "SUBPARTITION TEMPLATE (...) -> SUBPARTITIONS " + partitionTemplates.size());
            }
        }
        String subPartitionExpression = source.getTableSubPartitionColumns().stream().map(e -> "`" + e.getColumnName() + "`").collect(Collectors.joining(","));
        if (!PARTITION_SUBPARTITION_MAP.containsKey(target.getPartitionMethod()) || !PARTITION_SUBPARTITION_MAP.get(target.getPartitionMethod()).contains(subPartitionType)) {
            ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, "SUBPARTITION BY " + subPartitionType + "(" + subPartitionExpression + ") -> [NULL]");
            return target;
        }
        target.setSubPartitionMethod(subPartitionType);
        target.setSubPartitionExpression(subPartitionExpression);
        if (PARTITION_TYPE_MAP.containsKey(originSubPartitionType)) {
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, "SUBPARTITION BY " + originSubPartitionType + " -> SUBPARTITION BY " + subPartitionType);
        }
        return target;
    }

    static {
        PARTITION_TYPE_MAP.put("HASH", "KEY");
        PARTITION_TYPE_MAP.put("LIST", "LIST COLUMNS");
        PARTITION_TYPE_MAP.put("RANGE", "RANGE COLUMNS");
        List<String> subpartitions = Arrays.asList("HASH", "KEY");
        PARTITION_SUBPARTITION_MAP.put("RANGE", subpartitions);
        PARTITION_SUBPARTITION_MAP.put("RANGE COLUMNS", subpartitions);
        PARTITION_SUBPARTITION_MAP.put("LIST", subpartitions);
        PARTITION_SUBPARTITION_MAP.put("LIST COLUMNS", subpartitions);
    }
}

