/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.oboracle;

import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56Schema;
import com.oceanbase.obtools.dbdiff.model.mysql56.MySql56View;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xView;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.TextUtils;

@Conversion(sourceDbType=DbType.OBORACLE_22, targetDbType=DbType.MYSQL_56)
public class ObOracle22xMySql56ViewConverter
extends AbstractRuleBasedConverter<ObOracle22xView, MySql56View> {
    public ObOracle22xMySql56ViewConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public MySql56View convertByRule(ObOracle22xView source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        MySql56Schema schema = new MySql56Schema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        MySql56View target = new MySql56View(schema);
        target.setObjectName(source.getObjectName());
        target.setFullText(false);
        String targetText = TextUtils.replace(source.getText(), source.getSimpleObjectName(), target.getSimpleObjectName());
        targetText = TextUtils.replace(targetText, "\"", "`");
        target.setText(targetText);
        return target;
    }
}

