/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.oracle;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xColumn;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gColumn;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Conversion(sourceDbType=DbType.ORACLE_11GR2, targetDbType=DbType.OBMYSQL_14)
public class OracleObMySql14xColumnConverter
extends AbstractRuleBasedConverter<Oracle11gColumn, ObMySql14xColumn> {
    private static final Map<String, String> COLUMN_TYPE_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> BUILTIN_FUNC_MAPPING = new HashMap<String, String>();
    private static final Set<String> NOT_SUPPORT_BUILTIN_FUNC = new HashSet<String>();

    public OracleObMySql14xColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObMySql14xColumn convertByRule(Oracle11gColumn source) {
        boolean isSubsequentFrom12c;
        String dataType;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObMySql14xSchema schema = new ObMySql14xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObMySql14xColumn target = new ObMySql14xColumn(schema);
        target.setObjectName(source.getObjectName());
        target.setColumnName(source.getColumnName());
        String objectName = target.getSchemaObjectName();
        String originDataType = dataType = source.getDataType();
        StringBuilder sb = new StringBuilder();
        switch (dataType) {
            case "DATE": 
            case "ROWID": 
            case "CLOB": 
            case "BLOB": 
            case "NCLOB": 
            case "FLOAT": 
            case "BINARY_FLOAT": 
            case "BINARY_DOUBLE": {
                break;
            }
            case "NUMBER": {
                Integer dataPrecision = source.getDataPrecision();
                Integer dataScale = source.getDataScale();
                if (dataPrecision != null && dataPrecision > 0) {
                    sb.append("(").append(dataPrecision);
                    if (dataScale != null && dataScale > -1) {
                        sb.append(", ").append(Math.min(30, Math.min(dataPrecision, dataScale)));
                    }
                    sb.append(")");
                    break;
                }
                if (dataPrecision != null && dataScale == 0) {
                    sb.append("(38, 0)");
                    break;
                }
                sb.append("(65, 30)");
                break;
            }
            default: {
                if (dataType.startsWith("TIMESTAMP") || dataType.startsWith("INTERVAL")) break;
                String charUsed = source.getCharUsed();
                if ("B".equals(charUsed)) {
                    Long charLength = source.getCharLength();
                    if ("CHAR".equals(dataType) && charLength > 256L) {
                        dataType = "VARCHAR";
                        ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, target.getColumnName() + " " + originDataType + " -> " + dataType);
                    }
                    sb.append("(").append(source.getCharLength()).append(")");
                    break;
                }
                if ("C".equals(charUsed)) {
                    if ("CHAR".equals(dataType) || "NCHAR".equals(dataType)) {
                        dataType = "VARCHAR";
                    }
                    sb.append("(").append(source.getCharLength()).append(")");
                    break;
                }
                Long dataLength = source.getDataLength();
                if (dataLength == null || dataLength <= 0L) break;
                sb.append("(").append(dataLength).append(")");
            }
        }
        if (dataType.startsWith("INTERVAL") || dataType.startsWith("TIMESTAMP")) {
            int dataScale = Math.min(source.getDataScale(), 6);
            dataType = dataType.endsWith("LOCAL TIME ZONE") ? "TIMESTAMP(" + dataScale + ")" : (dataType.endsWith("TIME ZONE") ? "VARCHAR(50)" : (dataType.startsWith("TIMESTAMP") ? "DATETIME(" + dataScale + ")" : "VARCHAR(50)"));
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, target.getColumnName() + " " + originDataType + " -> " + dataType);
        } else {
            dataType = COLUMN_TYPE_MAPPING.getOrDefault(dataType, dataType);
            StringBuilder typeLength = new StringBuilder();
            typeLength.append(dataType).append((CharSequence)sb);
            if ("CHAR".equals(dataType) || "VARCHAR".equals(dataType)) {
                typeLength.append(" binary");
            }
            dataType = typeLength.toString();
            if (COLUMN_TYPE_MAPPING.containsKey(originDataType)) {
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, target.getColumnName() + " " + originDataType + " -> " + dataType);
            }
        }
        target.setColumnType(dataType);
        String columnDefault = source.getColumnDefault();
        if (columnDefault != null && !"null".equals(columnDefault.trim())) {
            String originColumnDefault = columnDefault;
            columnDefault = columnDefault.trim();
            if ("YES".equals(source.getVirtualColumn())) {
                target.setGenerationExpression(columnDefault.replace(source.getQuotaCharacter(), target.getQuotaCharacter()));
                if (!originColumnDefault.equals(target.getGenerationExpression())) {
                    ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, "The generation expression: " + originColumnDefault + " -> " + target.getGenerationExpression());
                }
            } else {
                boolean isEnclose;
                boolean bl = isEnclose = columnDefault.startsWith("('") && columnDefault.endsWith("')");
                if (isEnclose) {
                    columnDefault = columnDefault.substring(1, columnDefault.length() - 1);
                }
                if (originDataType.startsWith("INTERVAL") && columnDefault.startsWith("interval")) {
                    columnDefault = columnDefault.substring(columnDefault.indexOf(39), columnDefault.lastIndexOf(39) + 1);
                    ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, "The column default: " + originColumnDefault + " -> " + columnDefault);
                }
                if (NOT_SUPPORT_BUILTIN_FUNC.contains(columnDefault)) {
                    ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, "The column default: " + columnDefault + " -> [NULL]");
                    target.setColumnDefault(null);
                } else {
                    target.setColumnDefault(BUILTIN_FUNC_MAPPING.getOrDefault(columnDefault, columnDefault));
                    target.setDefaultUdt(!columnDefault.startsWith("'") || !columnDefault.endsWith("'"));
                }
                if (BUILTIN_FUNC_MAPPING.containsKey(columnDefault)) {
                    ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, target.getColumnName() + " default " + originColumnDefault + " -> " + target.getColumnDefault());
                }
            }
        }
        if ("N".equals(source.getNullable())) {
            target.setNullable("NO");
            if ("NULL".equalsIgnoreCase(target.getColumnDefault())) {
                target.setColumnDefault(null);
            }
        }
        if ((isSubsequentFrom12c = DbType.ORACLE_11GR2.isPrior(source.getOriginDbType())) && "YES".equals(source.getHiddenColumn())) {
            target.setExtra("INVISIBLE");
        }
        if (isSubsequentFrom12c && "YES".equals(source.getIdentityColumn())) {
            target.setColumnDefault(null);
            ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, "The identity of column `" + target.getColumnName() + "` " + target.getColumnType() + " -> [NULL]");
        }
        target.setDataType(source.getDataType());
        target.setColumnComment(source.getColumnComment());
        target.setOrdinalPosition(source.getOrdinalPosition());
        return target;
    }

    static {
        COLUMN_TYPE_MAPPING.put("VARCHAR2", "VARCHAR");
        COLUMN_TYPE_MAPPING.put("NVARCHAR2", "VARCHAR");
        COLUMN_TYPE_MAPPING.put("NUMBER", "NUMERIC");
        COLUMN_TYPE_MAPPING.put("LONG", "LONGTEXT");
        COLUMN_TYPE_MAPPING.put("RAW", "VARBINARY");
        COLUMN_TYPE_MAPPING.put("CLOB", "LONGTEXT");
        COLUMN_TYPE_MAPPING.put("NCLOB", "LONGTEXT");
        COLUMN_TYPE_MAPPING.put("BLOB", "LONGBLOB");
        COLUMN_TYPE_MAPPING.put("FLOAT", "DOUBLE");
        COLUMN_TYPE_MAPPING.put("BINARY_FLOAT", "DOUBLE");
        COLUMN_TYPE_MAPPING.put("BINARY_DOUBLE", "DOUBLE");
        COLUMN_TYPE_MAPPING.put("DATE", "DATETIME");
        COLUMN_TYPE_MAPPING.put("BFILE", "BLOB");
        COLUMN_TYPE_MAPPING.put("LONG RAW", "LONGBLOB");
        BUILTIN_FUNC_MAPPING.put("SYSDATE", "CURRENT_TIMESTAMP");
        BUILTIN_FUNC_MAPPING.put("sysdate", "CURRENT_TIMESTAMP");
        BUILTIN_FUNC_MAPPING.put("CURRENT_DATE", "CURRENT_TIMESTAMP");
        BUILTIN_FUNC_MAPPING.put("current_date", "CURRENT_TIMESTAMP");
        BUILTIN_FUNC_MAPPING.put("systimestamp", "CURRENT_TIMESTAMP");
        BUILTIN_FUNC_MAPPING.put("SYSTIMESTAMP", "CURRENT_TIMESTAMP");
        NOT_SUPPORT_BUILTIN_FUNC.add("SYS_GUID()");
        NOT_SUPPORT_BUILTIN_FUNC.add("sys_guid()");
    }
}

