/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.oracle;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xIndex;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gIndex;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gIndexPartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.List;

@Conversion(sourceDbType=DbType.ORACLE_11GR2, targetDbType=DbType.OBMYSQL_14)
public class OracleObMySql14xIndexConverter
extends AbstractRuleBasedConverter<Oracle11gIndex, ObMySql14xIndex> {
    public OracleObMySql14xIndexConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObMySql14xIndex convertByRule(Oracle11gIndex source) {
        Oracle11gIndexPartition indexPartition;
        String visibility;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObMySql14xSchema schema = new ObMySql14xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObMySql14xIndex target = new ObMySql14xIndex(schema);
        target.setObjectName(source.getObjectName());
        if ("UNIQUE".equals(source.getUniqueness())) {
            target.setIndexType(source.getUniqueness());
        }
        if ("INVISIBLE".equals(visibility = source.getVisibility())) {
            target.setVisible("NO");
        }
        target.setIndexSchema(source.getIndexSchema());
        target.setIndexName(source.getIndexName());
        String objectName = target.getSchemaObjectName();
        List<KeyColumn> indexColumns = source.getIndexColumns();
        for (KeyColumn indexColumn : indexColumns) {
            String columnName = indexColumn.getColumnName();
            String columnOrder = indexColumn.getColumnOrder();
            if ("DESC".equals(columnOrder)) {
                indexColumn.setColumnOrder("ASC");
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, columnName + " " + columnOrder + " -> " + columnName + " " + "ASC");
            }
            if (indexColumn.isExpression()) {
                indexColumn.setColumnName(columnName.replace('\"', '`'));
            }
            target.getIndexColumns().add(indexColumn);
        }
        Integer prefixLength = source.getPrefixLength();
        boolean isCompressed = "ENABLED".equals(source.getCompression());
        if (isCompressed && prefixLength != null && prefixLength > 0) {
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, "CREATE INDEX .... COMPRESS " + prefixLength + " -> CREATE INDEX ...");
        }
        if ("BITMAP".equals(source.getIndexType())) {
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, "CREATE BITMAP INDEX ... -> CREATE INDEX ...");
        }
        if ((indexPartition = source.getIndexPartition()) != null) {
            String locality = indexPartition.getLocality();
            if ("LOCAL".equals(locality)) {
                target.setLocality("LOCAL");
            } else {
                target.setLocality("GLOBAL");
                ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, "CREATE INDEX ... GLOBAL BY PARTITION " + indexPartition.getPartitioningType() + " ... -> CREATE INDEX ... GLOBAL");
            }
        }
        return target;
    }
}

