/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.oracle;

import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xView;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gView;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.TextUtils;

@Conversion(sourceDbType=DbType.ORACLE_11GR1, targetDbType=DbType.OBMYSQL_14)
public class OracleObMySql14xViewConverter
extends AbstractRuleBasedConverter<Oracle11gView, ObMySql14xView> {
    public OracleObMySql14xViewConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObMySql14xView convertByRule(Oracle11gView source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObMySql14xSchema schema = new ObMySql14xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObMySql14xView target = new ObMySql14xView(schema);
        target.setObjectName(source.getObjectName());
        target.setFullText(false);
        String targetText = TextUtils.replace(source.getText(), source.getSimpleObjectName(), target.getSimpleObjectName());
        targetText = TextUtils.replace(targetText, "\"", "`");
        target.setText(targetText);
        return target;
    }
}

