/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.oracle;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.constants.SqlConst;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xColumn;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleSequence;
import com.oceanbase.obtools.dbdiff.model.oracle11g.Oracle11gColumn;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

@Conversion(sourceDbType=DbType.ORACLE_11GR2, targetDbType=DbType.OBORACLE_22)
public class OracleObOracle22xColumnConverter
extends AbstractRuleBasedConverter<Oracle11gColumn, ObOracle22xColumn> {
    private static final Map<String, String> COLUMN_TYPE_MAPPING = new HashMap<String, String>();

    public OracleObOracle22xColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xColumn convertByRule(Oracle11gColumn source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xColumn column = new ObOracle22xColumn(schema);
        String dataType = source.getDataType().trim();
        Integer dataPrecision = source.getDataPrecision();
        column.setObjectName(source.getObjectName());
        column.setColumnName(source.getColumnName());
        column.setOrdinalPosition(source.getOrdinalPosition());
        column.setDataLength(source.getDataLength());
        column.setDataPrecision(dataPrecision);
        column.setDataScale(source.getDataScale());
        column.setNullable(source.getNullable());
        column.setColumnComment(source.getColumnComment());
        column.setHiddenColumn(source.getHiddenColumn());
        column.setVirtualColumn(source.getVirtualColumn());
        column.setCharUsed(source.getCharUsed());
        column.setCharLength(source.getCharLength());
        column.setCharacterSetName(source.getCharacterSetName());
        column.setCharColDeclLength(source.getCharColDeclLength());
        String wrappedName = column.getWrappedName();
        if ("YES".equals(source.getIdentityColumn())) {
            AbstractOracleSequence identityExpr = source.getIdentityExpr();
            if (identityExpr != null) {
                ChangeUtils.warn(ObjectType.TABLE, column.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, wrappedName + " GENERATED " + source.getGenerationType() + ("YES".equals(source.getDefaultOnNull()) ? " ON NULL" : "") + identityExpr.buildIdentityGrammar() + " -> [NULL]", "-- CREATE SEQUENCE xxx " + identityExpr.buildSequenceGrammar());
            }
        } else {
            column.setColumnDefault(source.getColumnDefault());
        }
        boolean isObOracle = DbType.OBORACLE_22.getType().equals(dbType.getType());
        if (isObOracle && !dbType.isPrior(DbType.OBORACLE_2230)) {
            COLUMN_TYPE_MAPPING.remove("FLOAT");
        }
        column.setDataType(COLUMN_TYPE_MAPPING.getOrDefault(dataType, dataType));
        if (isObOracle && !dbType.isPrior(DbType.OBORACLE_2250) && "NCLOB".equals(dataType)) {
            column.setDataType("NVARCHAR2");
            column.setDataLength(32767L);
            ChangeUtils.info(ObjectType.TABLE, column.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, wrappedName + " " + dataType + " -> NVARCHAR2(32767)");
        }
        if (COLUMN_TYPE_MAPPING.containsKey(dataType) && !"FLOAT".equals(dataType)) {
            ChangeUtils.info(ObjectType.TABLE, column.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, wrappedName + " " + dataType + " -> " + wrappedName + " " + column.getDataType());
        }
        if (isObOracle && dbType.isPrior(DbType.OBORACLE_2230) && "FLOAT".equals(dataType)) {
            dataPrecision = SqlConst.FLOAT_TO_NUMBER_FACTOR.multiply(BigDecimal.valueOf(dataPrecision.intValue())).intValue();
            column.setDataPrecision(dataPrecision);
            ChangeUtils.info(ObjectType.TABLE, column.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, wrappedName + " FLOAT -> " + wrappedName + " " + column.getDataType() + "(" + dataPrecision + ")");
        }
        return column;
    }

    public static Map<String, String> getCOLUMN_TYPE_MAPPING() {
        return COLUMN_TYPE_MAPPING;
    }

    static {
        COLUMN_TYPE_MAPPING.put("LONG", "CLOB");
        COLUMN_TYPE_MAPPING.put("FLOAT", "NUMBER");
        COLUMN_TYPE_MAPPING.put("LONG RAW", "BLOB");
    }
}

