/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.pgsql;

import com.oceanbase.obtools.dbdiff.constants.JdbcType;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractPostgresColumnConverter<PostgresColumn, T>
extends AbstractRuleBasedConverter<PostgresColumn, T> {
    protected static final String SERIAL_DEFAULT_REGEX = "nextval\\('(.+?)'::regclass\\)";
    protected static final String DEFAULT_EXPR_REGEX = "['$(]*(.+?)[')]*::[^)]+";
    protected static final String STRING_CONST_DEFAULT_REGEX = "^'(.*?)'::(character varying|bpchar|citext)$";
    protected static final String NULL_DEFAULT_REGEX = "NULL::.+";
    protected static final String BLANK_DEFAULT_REGEX = "''::.+";
    protected static final Set<String> UNSUPPORTED_FLOAT_DEFAULT_VALUE = new HashSet<String>();
    protected static final Set<String> DATE_TYPE_FUNCTIONS;

    public AbstractPostgresColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    protected String escapeColumnDefault(String dataType, String colDefault, String originColumnDefault) {
        if (colDefault == null) {
            return null;
        }
        if (JdbcType.isDateType(dataType, true)) {
            String upperDefault = colDefault.toUpperCase(Locale.getDefault());
            if (!(!DATE_TYPE_FUNCTIONS.stream().noneMatch(upperDefault::startsWith) || upperDefault.startsWith("(") && upperDefault.endsWith(")"))) {
                colDefault = "'" + colDefault + "'";
            }
        } else if (JdbcType.isStringType(dataType) && originColumnDefault.matches(STRING_CONST_DEFAULT_REGEX)) {
            colDefault = colDefault.replace("'", "''");
            colDefault = "'" + colDefault + "'";
        }
        return colDefault;
    }

    static {
        UNSUPPORTED_FLOAT_DEFAULT_VALUE.add("NaN");
        UNSUPPORTED_FLOAT_DEFAULT_VALUE.add("Infinity");
        UNSUPPORTED_FLOAT_DEFAULT_VALUE.add("-Infinity");
        DATE_TYPE_FUNCTIONS = new HashSet<String>();
        DATE_TYPE_FUNCTIONS.add("LOCALTIMESTAMP");
        DATE_TYPE_FUNCTIONS.add("CURRENT_TIMESTAMP");
        DATE_TYPE_FUNCTIONS.add("CURRENT_DATE");
        DATE_TYPE_FUNCTIONS.add("CURRENT_TIME");
        DATE_TYPE_FUNCTIONS.add("LOCALTIME");
    }
}

