/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.pgsql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import java.util.Map;

public abstract class AbstractPostgresPartitionConverter<S, T>
extends AbstractRuleBasedConverter<S, T> {
    public AbstractPostgresPartitionConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    protected String doSimpleParseKey(Map<String, String> partitionTypeMap, String partitionKey) {
        if (StringUtils.isNotBlank((CharSequence)partitionKey)) {
            for (String partType : partitionTypeMap.keySet()) {
                if (!partitionKey.startsWith(partType)) continue;
                return partitionKey.substring(partType.length() + 2, partitionKey.length() - 1);
            }
        }
        return partitionKey;
    }

    protected String doSimpleParseDesc(String partitionDesc, String partitionMethod) {
        if (StringUtils.isBlank((CharSequence)partitionMethod)) {
            return partitionDesc;
        }
        int index1 = partitionDesc.lastIndexOf("(");
        int index2 = partitionDesc.lastIndexOf(")");
        if (index1 != -1 && index2 != -1) {
            return partitionDesc.substring(index1 + 1, index2);
        }
        if ("DEFAULT".equalsIgnoreCase(partitionDesc) && partitionMethod.startsWith("RANGE")) {
            partitionDesc = "MAXVALUE";
        }
        return partitionDesc;
    }
}

