/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.pgsql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.constants.JdbcType;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.pgsql.AbstractPostgresColumnConverter;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xColumn;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresColumn;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@Conversion(sourceDbType=DbType.PGSQL_10, targetDbType=DbType.OBMYSQL_14)
public class PostgresObMySql14xColumnConverter
extends AbstractPostgresColumnConverter<PostgresColumn, ObMySql14xColumn> {
    private static final Map<String, String> DATA_TYPE_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> DEFAULT_VALUE_MAPPING = new HashMap<String, String>();

    public PostgresObMySql14xColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObMySql14xColumn convertByRule(PostgresColumn source) {
        String columnDefault;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObMySql14xSchema schema = new ObMySql14xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObMySql14xColumn target = new ObMySql14xColumn(schema);
        target.setObjectName(source.getObjectName());
        target.setColumnName(source.getColumnName());
        target.setColumnComment(source.getColumnComment());
        target.setOrdinalPosition(source.getOrdinalPosition());
        String originDataType = source.getDataType().toUpperCase(Locale.getDefault());
        if ("USER-DEFINED".equals(originDataType)) {
            originDataType = source.getUdtName().toUpperCase(Locale.getDefault());
        }
        target.setDataType(originDataType);
        switch (originDataType) {
            case "SERIAL": 
            case "SMALLSERIAL": 
            case "BIGSERIAL": {
                target.setExtra("auto_increment");
                break;
            }
            case "DECIMAL": 
            case "NUMERIC": {
                Integer precision = source.getNumericPrecision();
                Integer scale = source.getNumericScale();
                StringBuilder sb = new StringBuilder(64);
                sb.append("DECIMAL");
                if (precision != null && precision > 0 && precision < 66 && scale < 31) {
                    sb.append("(").append(precision);
                    if (scale != null && scale > -1) {
                        sb.append(",").append(Math.min(precision, scale));
                    }
                    sb.append(")");
                } else if (precision != null && scale == 0) {
                    sb.append("(38, 0)");
                } else {
                    sb.append("(65, 30)");
                }
                target.setColumnType(sb.toString());
                break;
            }
            case "CHARACTER": {
                Integer len = source.getCharacterMaximumLength();
                if (len != null && len > 0 && len < 256) {
                    target.setColumnType("CHAR(" + len + ")");
                    break;
                }
                if (len <= 255) break;
                target.setColumnType("LONGTEXT");
                break;
            }
            case "CHARACTER VARYING": {
                Integer len = source.getCharacterMaximumLength();
                if (len != null && len > 0 && len < 65535) {
                    target.setColumnType("VARCHAR(" + len + ")");
                    break;
                }
                if (len != 0 && len <= 65535) break;
                target.setColumnType("LONGTEXT");
                break;
            }
            case "JSON": 
            case "JSONB": {
                if (DbType.OBMYSQL_14.getType().equalsIgnoreCase(target.getDbType().getType()) && DbType.OBMYSQL_322.isSubsequent(target.getDbType()) || DbType.OBMYSQL_CE_312.getType().equalsIgnoreCase(target.getDbType().getType()) && DbType.OBMYSQL_CE_313.isSubsequent(target.getDbType())) {
                    target.setColumnType("LONGTEXT");
                    break;
                }
                target.setColumnType("JSON");
                break;
            }
            case "TIME WITH TIME ZONE": 
            case "TIME WITHOUT TIME ZONE": 
            case "TIMESTAMP WITH TIME ZONE": 
            case "TIMESTAMP WITHOUT TIME ZONE": {
                Object timePrecision = source.getDatetimePrecision();
                StringBuilder sb = new StringBuilder(64);
                if (originDataType.startsWith("TIMESTAMP")) {
                    sb.append("DATETIME");
                } else {
                    sb.append("TIME");
                }
                if (timePrecision != null && (Integer)timePrecision > 0) {
                    sb.append("(").append(timePrecision).append(")");
                }
                target.setColumnType(sb.toString());
                break;
            }
            default: {
                target.setColumnType(DATA_TYPE_MAPPING.getOrDefault(originDataType, originDataType));
            }
        }
        if (StringUtils.notEquals((CharSequence)originDataType, (CharSequence)target.getColumnType())) {
            ChangeUtils.info(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, target.getWrappedName() + " " + originDataType + " -> " + target.getColumnType());
        }
        target.setNullable(source.getNullable());
        target.setSrid(source.getSrid());
        String originColumnDefault = columnDefault = source.getColumnDefault();
        if (StringUtils.isNotEmpty((CharSequence)originColumnDefault)) {
            switch (originDataType) {
                case "REAL": 
                case "DOUBLE PRECISION": {
                    if (!originColumnDefault.matches("['$(]*(.+?)[')]*::[^)]+") || !UNSUPPORTED_FLOAT_DEFAULT_VALUE.contains(columnDefault = StringUtils.matchStr((String)originColumnDefault, (String)"['$(]*(.+?)[')]*::[^)]+", (int)1))) break;
                    ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, source.getWrappedName() + " default " + originColumnDefault + " -> [NULL]");
                    columnDefault = null;
                    break;
                }
                case "BOOLEAN": {
                    if (StringUtils.equalsIgnoreCase((CharSequence)"false", (CharSequence)originColumnDefault)) {
                        columnDefault = "0";
                        break;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)originColumnDefault)) break;
                    columnDefault = "1";
                    break;
                }
                default: {
                    if (JdbcType.isNoDefaultValueType(target.getColumnType()) || originColumnDefault.matches("NULL::.+")) {
                        columnDefault = null;
                        ChangeUtils.info(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, source.getWrappedName() + " default " + originColumnDefault + " -> [NULL]");
                        break;
                    }
                    if (originColumnDefault.matches("''::.+")) {
                        columnDefault = "''";
                        break;
                    }
                    if (originColumnDefault.matches("nextval\\('(.+?)'::regclass\\)")) {
                        if (!JdbcType.isNumericType(originDataType)) break;
                        columnDefault = null;
                        target.setExtra("auto_increment");
                        target.setGenerationExpression(null);
                        break;
                    }
                    if (originColumnDefault.matches("['$(]*(.+?)[')]*::[^)]+")) {
                        columnDefault = StringUtils.matchStr((String)originColumnDefault, (String)"['$(]*(.+?)[')]*::[^)]+", (int)1);
                        ChangeUtils.info(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, source.getWrappedName() + " default " + originColumnDefault + " -> " + columnDefault);
                        break;
                    }
                    columnDefault = DEFAULT_VALUE_MAPPING.getOrDefault(originColumnDefault, originColumnDefault);
                }
            }
            target.setColumnDefault(columnDefault);
        }
        String identityGen = source.getIdentityGeneration();
        if ("YES".equals(source.getIsIdentity()) && StringUtils.isNotBlank((CharSequence)identityGen)) {
            StringBuilder identityDef = source.getIdentityExpr().buildIdentityGrammar();
            ChangeUtils.info(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, source.getWrappedName() + " GENERATED " + identityGen + identityDef + " -> [NULL]");
        }
        String genExpr = source.getGenerationExpression();
        if ("ALWAYS".equals(source.getIsGenerated()) && StringUtils.isNotBlank((CharSequence)genExpr)) {
            int convertFlagIndex;
            if (genExpr.startsWith("(") && genExpr.endsWith(")") && (convertFlagIndex = (genExpr = genExpr.substring(1, genExpr.length() - 1)).lastIndexOf("::")) != -1) {
                genExpr = genExpr.substring(0, convertFlagIndex);
            }
            target.setGenerationExpression(genExpr);
            target.setExtra("STORED GENERATED");
        }
        return target;
    }

    static {
        DEFAULT_VALUE_MAPPING.put("now()", "CURRENT_TIMESTAMP");
        DATA_TYPE_MAPPING.put("CIDR", "VARCHAR(43)");
        DATA_TYPE_MAPPING.put("INET", "VARCHAR(43)");
        DATA_TYPE_MAPPING.put("MONEY", "DECIMAL(19,2)");
        DATA_TYPE_MAPPING.put("MACADDR", "VARCHAR(17)");
        DATA_TYPE_MAPPING.put("BOOLEAN", "TINYINT(1)");
        DATA_TYPE_MAPPING.put("UUID", "VARCHAR(36)");
        DATA_TYPE_MAPPING.put("INTERVAL", "TIME");
        DATA_TYPE_MAPPING.put("REAL", "FLOAT");
        DATA_TYPE_MAPPING.put("TEXT", "LONGTEXT");
        DATA_TYPE_MAPPING.put("TSQUERY", "LONGTEXT");
        DATA_TYPE_MAPPING.put("TSVECTOR", "LONGTEXT");
        DATA_TYPE_MAPPING.put("XML", "LONGTEXT");
        DATA_TYPE_MAPPING.put("BYTEA", "LONGBLOB");
        DATA_TYPE_MAPPING.put("DOUBLE PRECISION", "DOUBLE");
        DATA_TYPE_MAPPING.put("SERIAL", "INT");
        DATA_TYPE_MAPPING.put("SMALLSERIAL", "SMALLINT");
        DATA_TYPE_MAPPING.put("BIGSERIAL", "BIGINT");
        DATA_TYPE_MAPPING.put("BIT VARYING", "VARBINARY(65535)");
        DATA_TYPE_MAPPING.put("CITEXT", "LONGTEXT");
        DATA_TYPE_MAPPING.put("BOX", "POLYGON");
        DATA_TYPE_MAPPING.put("CIRCLE", "POLYGON");
        DATA_TYPE_MAPPING.put("POLYGON", "POLYGON");
        DATA_TYPE_MAPPING.put("POLYHEDRALSURFACE", "MULTIPOLYGON");
        DATA_TYPE_MAPPING.put("TRIANGLE", "POLYGON");
        DATA_TYPE_MAPPING.put("TIN", "MULTIPOLYGON");
        DATA_TYPE_MAPPING.put("LINE", "LINESTRING");
        DATA_TYPE_MAPPING.put("LSEG", "LINESTRING");
        DATA_TYPE_MAPPING.put("PATH", "LINESTRING");
        DATA_TYPE_MAPPING.put("PG_LSN", "UNKNOWN");
        DATA_TYPE_MAPPING.put("MACADDR8", "UNKNOWN");
        DATA_TYPE_MAPPING.put("PG_SNAPSHOT", "UNKNOWN");
        DATA_TYPE_MAPPING.put("TXID_SNAPSHOT", "UNKNOWN");
        DATA_TYPE_MAPPING.put("CIRCULARSTRING", "UNKNOWN");
        DATA_TYPE_MAPPING.put("COMPOUNDCURVE", "UNKNOWN");
        DATA_TYPE_MAPPING.put("CURVEPOLYGON", "UNKNOWN");
        DATA_TYPE_MAPPING.put("MULTICURVE", "UNKNOWN");
        DATA_TYPE_MAPPING.put("MULTISURFACE", "UNKNOWN");
    }
}

