/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.pgsql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xIndex;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresIndex;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import java.util.List;

@Conversion(sourceDbType=DbType.PGSQL_10, targetDbType=DbType.OBMYSQL_14)
public class PostgresObMySql14xIndexConverter
extends AbstractRuleBasedConverter<PostgresIndex, ObMySql14xIndex> {
    public PostgresObMySql14xIndexConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObMySql14xIndex convertByRule(PostgresIndex source) {
        String uniqueness;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObMySql14xSchema schema = new ObMySql14xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObMySql14xIndex target = new ObMySql14xIndex(schema);
        String indexType = source.getIndexType();
        target.setObjectName(source.getObjectName());
        target.setIndexName(source.getIndexName());
        target.setIndexSchema(source.getIndexSchema());
        target.setComment(source.getComment());
        if (StringUtils.isNotBlank((CharSequence)indexType)) {
            if ("GIST".equalsIgnoreCase(indexType)) {
                target.setIndexType("SPATIAL");
            } else {
                target.setIndexType(source.getIndexType());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(uniqueness = source.getUniqueness()))) {
            if ("UNIQUE".equalsIgnoreCase(uniqueness)) {
                target.setNonunique(0);
                target.setIndexType("UNIQUE");
            } else {
                target.setNonunique(1);
            }
        }
        List<KeyColumn> indexColumns = source.getIndexColumns();
        indexColumns.forEach(e -> e.setColumnOrder("ASC"));
        target.getIndexColumns().addAll(indexColumns);
        return target;
    }
}

