/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.pgsql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.pgsql.AbstractPostgresPartitionConverter;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTablePartition;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xTablePartition;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresTablePartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Conversion(sourceDbType=DbType.PGSQL_10, targetDbType=DbType.OBMYSQL_3X)
public class PostgresObMySql14xPartitionConverter
extends AbstractPostgresPartitionConverter<PostgresTablePartition, ObMySql14xTablePartition> {
    private static final Map<String, String> PARTITION_TYPE_MAP = new HashMap<String, String>();

    public PostgresObMySql14xPartitionConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObMySql14xTablePartition convertByRule(PostgresTablePartition source) {
        boolean isSimpleColumnReference;
        String partitionMethod;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObMySql14xSchema schema = new ObMySql14xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObMySql14xTablePartition target = new ObMySql14xTablePartition(schema);
        target.setObjectName(source.getObjectName());
        String objectName = target.getSchemaObjectName();
        String originPartitionMethod = partitionMethod = source.getPartitionMethod();
        boolean bl = isSimpleColumnReference = StringUtils.isBlank((CharSequence)source.getPartitionExpression()) && !"0".equals(source.getPartAttrs());
        if (isSimpleColumnReference) {
            partitionMethod = PARTITION_TYPE_MAP.getOrDefault(partitionMethod, partitionMethod);
            if (PARTITION_TYPE_MAP.containsKey(originPartitionMethod)) {
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, "PARTITION BY " + originPartitionMethod + " -> PARTITION BY " + partitionMethod);
            }
        }
        target.setPartitionMethod(partitionMethod);
        target.setPartitionExpression(this.doSimpleParseKey(PARTITION_TYPE_MAP, source.getPartitionKey()));
        List<PostgresTablePartition.PostgresPartitionItem> sourcePartitions = source.getTablePartitions();
        Collection<AbstractMySqlTablePartition.MySqlPartitionItem> targetPartitions = target.getTablePartitions();
        Map<String, List<AbstractMySqlTablePartition.MySqlPartitionItem>> targetSubPartitionMapping = target.getTableSubPartitionMapping();
        int position = 0;
        String subPartitionMethod = null;
        String subPartitionExpression = null;
        String partitionKey = null;
        boolean isComposite = false;
        boolean isSubpartitionSimpleColumnReferenced = false;
        int partLevel = 1;
        for (PostgresTablePartition.PostgresPartitionItem item : sourcePartitions) {
            AbstractMySqlTablePartition.MySqlPartitionItem targetItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
            isComposite = item.isHasSubClass();
            targetItem.setPartitionName(item.getPartitionName());
            targetItem.setPartitionDescription(this.doSimpleParseDesc(item.getPartitionBound(), target.getPartitionMethod()));
            targetItem.setPartitionOrdinalPosition(position);
            targetPartitions.add(targetItem);
            String prevPartitionKey = partitionKey;
            partitionKey = item.getPartitionKey();
            if (prevPartitionKey != null && !prevPartitionKey.equals(partitionKey)) {
                ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, "SUBPARTITIONS -> [NULL]");
                isComposite = false;
                continue;
            }
            subPartitionMethod = item.getPartitionMethod();
            if (isComposite && !"0".equals(item.getPartattrs())) {
                isSubpartitionSimpleColumnReferenced = true;
            }
            subPartitionExpression = this.doSimpleParseKey(PARTITION_TYPE_MAP, item.getPartitionKey());
            List<PostgresTablePartition.PostgresPartitionItem> subItems = item.getSubPartitions();
            if (isComposite) {
                int position2 = 0;
                ArrayList<AbstractMySqlTablePartition.MySqlPartitionItem> targetSubPartitions = new ArrayList<AbstractMySqlTablePartition.MySqlPartitionItem>();
                for (PostgresTablePartition.PostgresPartitionItem subItem : subItems) {
                    AbstractMySqlTablePartition.MySqlPartitionItem targetSubItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
                    targetSubItem.setSubPartitionName(subItem.getPartitionName());
                    targetSubItem.setPartitionDescription(this.doSimpleParseDesc(subItem.getPartitionBound(), item.getPartitionMethod()));
                    targetSubItem.setSubPartitionOrdinalPosition(position2++);
                    targetSubPartitions.add(targetSubItem);
                }
                targetSubPartitionMapping.put(String.valueOf(position), targetSubPartitions);
            }
            ++position;
        }
        if (targetPartitions.size() != targetSubPartitionMapping.size()) {
            isComposite = false;
        }
        if (isComposite) {
            partLevel = 2;
            if (isSubpartitionSimpleColumnReferenced) {
                String originSubpartitionMethod = subPartitionMethod;
                subPartitionMethod = PARTITION_TYPE_MAP.getOrDefault(subPartitionMethod, subPartitionMethod);
                if (PARTITION_TYPE_MAP.containsKey(originPartitionMethod)) {
                    ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, "SUBPARTITION BY " + originSubpartitionMethod + " -> SUBPARTITION BY " + subPartitionMethod);
                }
            }
            target.setSubPartitionMethod(subPartitionMethod);
            target.setSubPartitionExpression(subPartitionExpression);
        } else {
            targetSubPartitionMapping.clear();
        }
        target.setPartLevel(partLevel);
        return target;
    }

    static {
        PARTITION_TYPE_MAP.put("HASH", "KEY");
        PARTITION_TYPE_MAP.put("LIST", "LIST COLUMNS");
        PARTITION_TYPE_MAP.put("RANGE", "RANGE COLUMNS");
    }
}

