/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.pgsql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xCheck;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresCheck;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;

@Conversion(sourceDbType=DbType.PGSQL_10, targetDbType=DbType.OBORACLE_22)
public class PostgresObOracle22xCheckConverter
extends AbstractRuleBasedConverter<PostgresCheck, ObOracle22xCheck> {
    public PostgresObOracle22xCheckConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xCheck convertByRule(PostgresCheck source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xCheck target = new ObOracle22xCheck(schema);
        target.setConstraintName(source.getConstraintName());
        target.setSearchCondition(this.parseCheckClause(source.getCheckClause()));
        target.setObjectName(source.getObjectName());
        String comment = source.getComment();
        if (StringUtils.isNotBlank((CharSequence)comment)) {
            ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, target.getConstraintName() + " CHECK COMMENT:" + comment + " -> [NULL]");
        }
        return target;
    }

    private String parseCheckClause(String checkClause) {
        int index1 = checkClause.indexOf("(");
        int index2 = checkClause.lastIndexOf(")");
        if (index1 != -1 && index2 != -1) {
            return checkClause.substring(index1 + 1, index2);
        }
        return checkClause;
    }
}

