/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.pgsql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.pgsql.AbstractPostgresColumnConverter;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xColumn;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSequence;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresColumn;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresSequence;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@Conversion(sourceDbType=DbType.PGSQL_10, targetDbType=DbType.OBORACLE_22)
public class PostgresObOracle22xColumnConverter
extends AbstractPostgresColumnConverter<PostgresColumn, ObOracle22xColumn> {
    private static final Map<String, String> DATATYPE_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> COLUMN_DEFAULT_MAPPING;

    public PostgresObOracle22xColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xColumn convertByRule(PostgresColumn source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xColumn target = new ObOracle22xColumn(schema);
        target.setObjectName(source.getObjectName());
        target.setColumnName(source.getColumnName());
        target.setOrdinalPosition(source.getOrdinalPosition());
        target.setColumnComment(source.getColumnComment());
        String originDataType = source.getDataType().toUpperCase(Locale.getDefault());
        if ("USER-DEFINED".equals(originDataType)) {
            originDataType = source.getUdtName().toUpperCase(Locale.getDefault());
        }
        target.setDataType(DATATYPE_MAPPING.getOrDefault(originDataType, "UNKNOWN"));
        switch (originDataType) {
            case "BIGINT": 
            case "BIGSERIAL": {
                target.setDataPrecision(20);
                break;
            }
            case "BIT": 
            case "BIT VARYING": {
                Integer characterMaximumLength = source.getCharacterMaximumLength();
                if (characterMaximumLength == 0 || characterMaximumLength > 16000) {
                    target.setDataType("BLOB");
                    break;
                }
                target.setDataLength(Long.valueOf((characterMaximumLength = Integer.valueOf(Math.max(characterMaximumLength, 8))) % 8 == 0 ? characterMaximumLength / 8 : characterMaximumLength / 8 + 1));
                break;
            }
            case "BOOLEAN": {
                target.setDataPrecision(1);
                break;
            }
            case "CHARACTER": {
                Integer len = source.getCharacterMaximumLength();
                if (len != null && len > 0 && len <= 2000) {
                    target.setCharLength(len.longValue());
                    target.setCharUsed("C");
                    break;
                }
                target.setDataType("CLOB");
                break;
            }
            case "CHARACTER VARYING": {
                Integer len = source.getCharacterMaximumLength();
                if (len != null && len > 0 && len <= Short.MAX_VALUE) {
                    target.setCharLength(len.longValue());
                    target.setCharUsed("C");
                    break;
                }
                target.setDataType("CLOB");
                break;
            }
            case "INET": 
            case "CIDR": {
                target.setDataLength(43L);
                break;
            }
            case "INTEGER": 
            case "SERIAL": {
                target.setDataPrecision(10);
                break;
            }
            case "INTERVAL": {
                target.setDataLength(50L);
                break;
            }
            case "MACADDR": {
                target.setDataLength(17L);
                break;
            }
            case "MACADDR8": {
                target.setDataLength(23L);
                break;
            }
            case "MONEY": {
                target.setDataPrecision(17);
                target.setDataScale(2);
                break;
            }
            case "NUMERIC": {
                Object precision = source.getNumericPrecision();
                if (precision != null && (Integer)precision > 0) {
                    target.setDataPrecision(Math.min((Integer)precision, 38));
                } else {
                    target.setDataPrecision(-1);
                }
                Integer scale = source.getNumericScale();
                if (scale == null) break;
                if (scale == 0) {
                    target.setDataScale(-1);
                    break;
                }
                target.setDataScale(Math.min(127, Math.max(scale, -84)));
                break;
            }
            case "SMALLINT": 
            case "SMALLSERIAL": {
                target.setDataPrecision(5);
                break;
            }
            case "UUID": {
                target.setDataLength(36L);
                break;
            }
            case "TIME WITH TIME ZONE": 
            case "TIME WITHOUT TIME ZONE": 
            case "TIMESTAMP WITH TIME ZONE": 
            case "TIMESTAMP WITHOUT TIME ZONE": {
                target.setDataType(target.getDataType().replace("TIMESTAMP", "TIMESTAMP(" + source.getDatetimePrecision() + ")"));
                break;
            }
            case "JSON": {
                if (DbType.OBORACLE_410.isPriorFrom(dbType)) {
                    target.setDataType("JSON");
                    break;
                }
            }
            case "TXID_SNAPSHOT": {
                target.setDataLength(32767L);
            }
        }
        if (target.getDataType().equalsIgnoreCase("UNKNOWN")) {
            throw new UnsupportedGrammarException(target.getSchemaObjectName(), "The data type: \"" + originDataType + "\" is unsupported in " + dbType);
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)target.getDataType(), (CharSequence)originDataType)) {
            ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, source.getWrappedName() + " " + originDataType + " -> " + target.getWrappedName() + " " + this.buildColumnType(target));
        }
        target.setNullable("NO".equals(source.getNullable()) ? "N" : "Y");
        String columnDefault = source.getColumnDefault();
        String originColumnDefault = source.getColumnDefault();
        if (StringUtils.isNotEmpty((CharSequence)originColumnDefault)) {
            switch (originDataType) {
                case "REAL": 
                case "DOUBLE PRECISION": {
                    if (!originColumnDefault.matches("['$(]*(.+?)[')]*::[^)]+") || !UNSUPPORTED_FLOAT_DEFAULT_VALUE.contains(columnDefault = StringUtils.matchStr((String)originColumnDefault, (String)"['$(]*(.+?)[')]*::[^)]+", (int)1))) break;
                    ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, source.getWrappedName() + " default " + originColumnDefault + " -> [NULL]");
                    columnDefault = null;
                    break;
                }
                case "BOOLEAN": {
                    if (StringUtils.equalsIgnoreCase((CharSequence)"false", (CharSequence)originColumnDefault)) {
                        columnDefault = "0";
                        break;
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)originColumnDefault)) break;
                    columnDefault = "1";
                    break;
                }
                default: {
                    if (originColumnDefault.matches("NULL::.+")) {
                        columnDefault = null;
                        break;
                    }
                    if (originColumnDefault.matches("''::.+")) {
                        columnDefault = "";
                        break;
                    }
                    if (source.getSequence() != null) {
                        if (DbType.OBORACLE_323.getType().equalsIgnoreCase(dbType.getType()) && DbType.OBORACLE_323.isSubsequent(dbType)) {
                            columnDefault = null;
                        } else {
                            ObOracle22xSequence sequence = this.convertSerialDefault(target, source.getSequence());
                            target.getSequenceMapping().put(sequence.getObjectName(), sequence);
                            columnDefault = sequence.getSchemaObjectName() + ".nextval";
                        }
                        ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, source.getWrappedName() + " default " + originColumnDefault + " -> " + (columnDefault == null ? "[NULL]" : columnDefault));
                        break;
                    }
                    if (originColumnDefault.matches("['$(]*(.+?)[')]*::[^)]+")) {
                        columnDefault = StringUtils.matchStr((String)originColumnDefault, (String)"['$(]*(.+?)[')]*::[^)]+", (int)1);
                        ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, source.getWrappedName() + " default " + originColumnDefault + " -> " + columnDefault);
                        break;
                    }
                    columnDefault = COLUMN_DEFAULT_MAPPING.getOrDefault(originColumnDefault, originColumnDefault);
                    if (originColumnDefault.equals(columnDefault)) break;
                    ChangeUtils.warn(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, source.getWrappedName() + " default " + originColumnDefault + " -> " + columnDefault);
                }
            }
            target.setColumnDefault(this.escapeColumnDefault(target.getDataType(), columnDefault, originColumnDefault));
        }
        String genExpr = source.getGenerationExpression();
        if ("ALWAYS".equals(source.getIsGenerated()) && StringUtils.isNotBlank((CharSequence)genExpr)) {
            int convertFlagIndex;
            if (genExpr.startsWith("(") && genExpr.endsWith(")") && (convertFlagIndex = (genExpr = genExpr.substring(1, genExpr.length() - 1)).lastIndexOf("::")) != -1) {
                genExpr = genExpr.substring(0, convertFlagIndex);
            }
            target.setColumnDefault(genExpr);
            target.setVirtualColumn("YES");
        }
        String identityGen = source.getIdentityGeneration();
        if ("YES".equals(source.getIsIdentity()) && StringUtils.isNotBlank((CharSequence)identityGen)) {
            StringBuilder identityDef = source.getIdentityExpr().buildIdentityGrammar();
            ChangeUtils.info(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, source.getWrappedName() + " GENERATED " + identityGen + identityDef + " -> [NULL]");
            target.setIdentityColumn("YES");
            target.setColumnDefault(null);
        }
        return target;
    }

    private ObOracle22xSequence convertSerialDefault(ObOracle22xColumn column, PostgresSequence pgSequence) {
        ObOracle22xSchema schema = (ObOracle22xSchema)column.getSchema();
        ObOracle22xSequence sequence = new ObOracle22xSequence(schema);
        sequence.setObjectName(pgSequence.getSequenceName());
        sequence.setCache(pgSequence.getCache());
        sequence.setCycle(pgSequence.getCycle());
        sequence.setStart(pgSequence.getStart());
        sequence.setMinValue(pgSequence.getMinValue());
        sequence.setMaxValue(pgSequence.getMaxValue());
        sequence.setIncrement(pgSequence.getIncrement());
        return sequence;
    }

    private String buildColumnType(ObOracle22xColumn column) {
        StringBuilder sb = new StringBuilder();
        sb.append(column.getDataType());
        if (column.getDataLength() != null || column.getDataPrecision() != null) {
            sb.append("(");
            if (column.getDataLength() != null) {
                sb.append(column.getDataLength());
            } else {
                sb.append(column.getDataPrecision());
                if (column.getDataScale() != null) {
                    sb.append(",").append(column.getDataScale());
                }
            }
            sb.append(")");
        }
        return sb.toString();
    }

    static {
        DATATYPE_MAPPING.put("BIGINT", "NUMBER");
        DATATYPE_MAPPING.put("BIGSERIAL", "NUMBER");
        DATATYPE_MAPPING.put("BIT", "RAW");
        DATATYPE_MAPPING.put("BIT VARYING", "RAW");
        DATATYPE_MAPPING.put("BOOLEAN", "NUMBER");
        DATATYPE_MAPPING.put("BYTEA", "BLOB");
        DATATYPE_MAPPING.put("CHARACTER", "CHAR");
        DATATYPE_MAPPING.put("CHARACTER VARYING", "VARCHAR2");
        DATATYPE_MAPPING.put("CIDR", "VARCHAR2");
        DATATYPE_MAPPING.put("DATE", "DATE");
        DATATYPE_MAPPING.put("DOUBLE PRECISION", "BINARY_DOUBLE");
        DATATYPE_MAPPING.put("INTEGER", "NUMBER");
        DATATYPE_MAPPING.put("INET", "VARCHAR2");
        DATATYPE_MAPPING.put("INTERVAL", "VARCHAR2");
        DATATYPE_MAPPING.put("JSON", "CLOB");
        DATATYPE_MAPPING.put("JSONB", "BLOB");
        DATATYPE_MAPPING.put("MACADDR", "VARCHAR2");
        DATATYPE_MAPPING.put("MACADDR8", "VARCHAR2");
        DATATYPE_MAPPING.put("MONEY", "NUMBER");
        DATATYPE_MAPPING.put("NUMERIC", "NUMBER");
        DATATYPE_MAPPING.put("DECIMAL", "NUMBER");
        DATATYPE_MAPPING.put("REAL", "BINARY_FLOAT");
        DATATYPE_MAPPING.put("SMALLINT", "NUMBER");
        DATATYPE_MAPPING.put("SMALLSERIAL", "NUMBER");
        DATATYPE_MAPPING.put("SERIAL", "NUMBER");
        DATATYPE_MAPPING.put("TEXT", "CLOB");
        DATATYPE_MAPPING.put("TSQUERY", "CLOB");
        DATATYPE_MAPPING.put("TSVECTOR", "CLOB");
        DATATYPE_MAPPING.put("TXID_SNAPSHOT", "VARCHAR2");
        DATATYPE_MAPPING.put("UUID", "CHAR");
        DATATYPE_MAPPING.put("TIME WITH TIME ZONE", "TIMESTAMP WITH TIME ZONE");
        DATATYPE_MAPPING.put("TIME WITHOUT TIME ZONE", "TIMESTAMP");
        DATATYPE_MAPPING.put("TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH TIME ZONE");
        DATATYPE_MAPPING.put("TIMESTAMP WITHOUT TIME ZONE", "TIMESTAMP");
        DATATYPE_MAPPING.put("CITEXT", "CLOB");
        DATATYPE_MAPPING.put("XML", "XMLTYPE");
        COLUMN_DEFAULT_MAPPING = new HashMap<String, String>();
        COLUMN_DEFAULT_MAPPING.put("now()", "CURRENT_TIMESTAMP");
    }
}

