/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.pgsql;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xIndex;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresIndex;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import java.util.List;

@Conversion(sourceDbType=DbType.PGSQL_10, targetDbType=DbType.OBORACLE_22)
public class PostgresObOracle22xIndexConverter
extends AbstractRuleBasedConverter<PostgresIndex, ObOracle22xIndex> {
    public PostgresObOracle22xIndexConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xIndex convertByRule(PostgresIndex source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xIndex target = new ObOracle22xIndex(schema);
        target.setIndexType(source.getIndexType());
        target.setObjectName(source.getObjectName());
        target.setIndexName(source.getIndexName());
        target.setIndexSchema(source.getIndexSchema());
        target.setComment(source.getComment());
        String uniqueness = source.getUniqueness();
        if (StringUtils.isNotBlank((CharSequence)uniqueness) && "UNIQUE".equalsIgnoreCase(uniqueness)) {
            target.setUniqueness("UNIQUE");
            target.setIndexType("UNIQUE");
        }
        List<KeyColumn> indexColumns = source.getIndexColumns();
        indexColumns.forEach(e -> e.setColumnOrder("ASC"));
        target.getIndexColumns().addAll(indexColumns);
        return target;
    }
}

