/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.pgsql;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.common.utils.MapUtils;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.pgsql.AbstractPostgresPartitionConverter;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTablePartition;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import com.oceanbase.obtools.dbdiff.model.pgsql.PostgresTablePartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Conversion(sourceDbType=DbType.PGSQL_10, targetDbType=DbType.OBORACLE_22)
public class PostgresObOracle22xPartitionConverter
extends AbstractPostgresPartitionConverter<PostgresTablePartition, ObOracle22xTablePartition> {
    private static final Map<String, String> PARTITION_TYPE_MAP = new HashMap<String, String>();

    public PostgresObOracle22xPartitionConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xTablePartition convertByRule(PostgresTablePartition source) {
        boolean isSimpleColumnReference;
        String partitionMethod;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xTablePartition target = new ObOracle22xTablePartition(schema);
        target.setObjectName(source.getObjectName());
        String objectName = target.getSchemaObjectName();
        String originPartitionMethod = partitionMethod = source.getPartitionMethod();
        boolean bl = isSimpleColumnReference = StringUtils.isBlank((CharSequence)source.getPartitionExpression()) && !"0".equals(source.getPartAttrs());
        if (!isSimpleColumnReference) {
            target.setTablePartitionExpression(source.getPartitionExpression());
        } else {
            String partitionExpression = this.doSimpleParseKey(PARTITION_TYPE_MAP, source.getPartitionKey());
            Arrays.stream(partitionExpression.split(",")).map(name -> {
                AbstractOracleTablePartition.OracleTablePartitionColumn column = new AbstractOracleTablePartition.OracleTablePartitionColumn();
                column.setExpression(false);
                column.setColumnName(name.trim());
                return column;
            }).forEach(column -> target.getTablePartitionColumns().add((AbstractOracleTablePartition.OracleTablePartitionColumn)column));
        }
        partitionMethod = PARTITION_TYPE_MAP.getOrDefault(partitionMethod, partitionMethod);
        if (StringUtils.notEqualsIgnoreCase((CharSequence)originPartitionMethod, (CharSequence)partitionMethod)) {
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, "PARTITION BY " + originPartitionMethod + " -> PARTITION BY " + partitionMethod);
        }
        target.setPartitioningType(partitionMethod);
        target.setPartitioningKeyCount(source.getPartKeyColumnNum());
        List<PostgresTablePartition.PostgresPartitionItem> sourcePartitions = source.getTablePartitions();
        Collection<AbstractOracleTablePartition.OracleTablePartitionItem> targetPartitions = target.getTablePartitions();
        Map<String, List<AbstractOracleTablePartition.OracleTablePartitionItem>> targetSubPartitionMapping = target.getTableSubPartitionMapping();
        String subPartitionMethod = null;
        String partitionKey = null;
        boolean isComposite = false;
        for (PostgresTablePartition.PostgresPartitionItem sourcePartition : sourcePartitions) {
            boolean isSimpleColumnReferSubPartition;
            isComposite = sourcePartition.isHasSubClass();
            AbstractOracleTablePartition.OracleTablePartitionItem targetItem = new AbstractOracleTablePartition.OracleTablePartitionItem();
            targetItem.setPartitionName(sourcePartition.getPartitionName());
            String partitionBound = sourcePartition.getPartitionBound();
            targetItem.setHighValue(this.doSimpleParseDesc(partitionBound, partitionMethod));
            targetPartitions.add(targetItem);
            String prevPartitionKey = partitionKey;
            partitionKey = sourcePartition.getPartitionKey();
            if (prevPartitionKey != null && !prevPartitionKey.equals(partitionKey)) {
                ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, "PARTITION BY " + partitionKey + " -> [NULL]");
                isComposite = false;
                continue;
            }
            boolean bl2 = isSimpleColumnReferSubPartition = !"0".equals(sourcePartition.getPartattrs());
            if (!isComposite) continue;
            subPartitionMethod = sourcePartition.getPartitionMethod();
            if (isSimpleColumnReferSubPartition) {
                if (CollectionUtils.isEmpty(target.getTableSubPartitionColumns())) {
                    String subPartitionExpr = this.doSimpleParseKey(PARTITION_TYPE_MAP, partitionKey);
                    List subPartitionColumns = Stream.of(subPartitionExpr.split(",")).map(name -> {
                        AbstractOracleTablePartition.OracleTablePartitionColumn column = new AbstractOracleTablePartition.OracleTablePartitionColumn();
                        column.setColumnName(name.trim());
                        return column;
                    }).collect(Collectors.toList());
                    target.getTableSubPartitionColumns().addAll(subPartitionColumns);
                    target.setSubPartitioningKeyCount(subPartitionColumns.size());
                }
            } else {
                target.setTableSubPartitionExpression(this.doSimpleParseKey(PARTITION_TYPE_MAP, sourcePartition.getPartitionKey()));
            }
            List<PostgresTablePartition.PostgresPartitionItem> subItems = sourcePartition.getSubPartitions();
            ArrayList<AbstractOracleTablePartition.OracleTablePartitionItem> targetSubPartitions = new ArrayList<AbstractOracleTablePartition.OracleTablePartitionItem>();
            for (PostgresTablePartition.PostgresPartitionItem subItem : subItems) {
                AbstractOracleTablePartition.OracleTablePartitionItem targetSubItem = new AbstractOracleTablePartition.OracleTablePartitionItem();
                targetSubItem.setSubPartitionName(subItem.getPartitionName());
                targetSubItem.setHighValue(this.doSimpleParseDesc(subItem.getPartitionBound(), partitionMethod));
                targetSubPartitions.add(targetSubItem);
            }
            targetSubPartitionMapping.put(targetItem.getPartitionName(), targetSubPartitions);
        }
        if (targetPartitions.size() != targetSubPartitionMapping.size()) {
            isComposite = false;
            if (MapUtils.isNotEmpty(targetSubPartitionMapping)) {
                ChangeUtils.warn(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.DISCARD, "SUBPARTITION -> [NULL]");
            }
        }
        if (isComposite) {
            String originSubpartitionMethod = subPartitionMethod;
            if (StringUtils.notEqualsIgnoreCase((CharSequence)(subPartitionMethod = (String)PARTITION_TYPE_MAP.getOrDefault(subPartitionMethod, subPartitionMethod)), (CharSequence)originSubpartitionMethod)) {
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, "SUBPARTITION BY " + originSubpartitionMethod + " -> SUBPARTITION BY " + subPartitionMethod);
            }
            target.setSubPartitioningType(subPartitionMethod);
        } else {
            targetSubPartitionMapping.clear();
        }
        return target;
    }

    static {
        PARTITION_TYPE_MAP.put("HASH", "HASH");
        PARTITION_TYPE_MAP.put("LIST", "LIST");
        PARTITION_TYPE_MAP.put("RANGE", "RANGE");
    }
}

