/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.polarx;

import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xTablePartition;
import com.oceanbase.obtools.dbdiff.model.polarx.PolarXTablePartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@Conversion(sourceDbType=DbType.POLARX_10, targetDbType=DbType.OBMYSQL_14)
public class PolarXAutoObMysqlPartitionConverter
extends AbstractRuleBasedConverter<PolarXTablePartition, ObMySql14xTablePartition> {
    private static final Map<String, String> PARTITION_METHOD_MAP = new HashMap<String, String>();

    public PolarXAutoObMysqlPartitionConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObMySql14xTablePartition convertByRule(PolarXTablePartition source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObMySql14xSchema schema = new ObMySql14xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getDbType());
        ObMySql14xTablePartition target = new ObMySql14xTablePartition(schema);
        target.setObjectName(source.getObjectName());
        if (source.getPartitionTableType() == 1) {
            return null;
        }
        String partitionMethod = source.getPartitionMethod().toUpperCase(Locale.getDefault());
        target.setPartitionMethod(PARTITION_METHOD_MAP.getOrDefault(partitionMethod, partitionMethod));
        target.setPartitionExpression(source.getPartitionExpression());
        target.getTablePartitions().addAll(source.getTablePartitions());
        return target;
    }

    static {
        PARTITION_METHOD_MAP.put("LIST_COLUMNS", "LIST COLUMNS");
        PARTITION_METHOD_MAP.put("RANGE_COLUMNS", "RANGE COLUMNS");
    }
}

