/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.polarx;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsIndex;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xIndex;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.List;

@Conversion(sourceDbType=DbType.POLARX_10, targetDbType=DbType.OBMYSQL_14)
public class PolarXDrdsObMysqlIndexConverter
extends AbstractRuleBasedConverter<DrdsIndex, ObMySql14xIndex> {
    public PolarXDrdsObMysqlIndexConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObMySql14xIndex convertByRule(DrdsIndex source) {
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObMySql14xSchema schema = new ObMySql14xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getDbType());
        ObMySql14xIndex target = new ObMySql14xIndex(schema);
        target.setObjectName(source.getObjectName());
        target.setIndexSchema(source.getIndexSchema());
        target.setIndexName(source.getIndexName());
        String objectName = target.getSchemaObjectName();
        List<KeyColumn> indexColumns = source.getIndexColumns();
        for (KeyColumn indexColumn : indexColumns) {
            if ("COVERING".equals(indexColumn.getComment())) continue;
            String columnName = indexColumn.getColumnName();
            String columnOrder = indexColumn.getColumnOrder();
            if ("D".equals(columnOrder)) {
                indexColumn.setColumnOrder("ASC");
                ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, columnName + " " + columnOrder + " -> " + columnName + " " + "ASC");
            }
            target.getIndexColumns().add(indexColumn);
        }
        String indexType = source.getIndexType();
        if (0 == source.getNonunique()) {
            indexType = "UNIQUE";
        }
        String locality = source.isGlobal() || "GLOBAL".equals(indexType) ? "GLOBAL" : "LOCAL";
        target.setIndexType(indexType);
        target.setLocality(locality);
        return target;
    }
}

