/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.polarx;

import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.mapper.converter.polarx.strategy.DrdsPartitionConvertStrategyFactory;
import com.oceanbase.obtools.dbdiff.mapper.converter.polarx.strategy.PartitionConvertStrategy;
import com.oceanbase.obtools.dbdiff.model.drds.AbstractDrdsPartition;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsTablePartition;
import com.oceanbase.obtools.dbdiff.model.mysql.AbstractMySqlTablePartition;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xSchema;
import com.oceanbase.obtools.dbdiff.model.obmysql14x.ObMySql14xTablePartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Conversion(sourceDbType=DbType.POLARX_10, targetDbType=DbType.OBMYSQL_14)
public class PolarXDrdsObMysqlPartitionConverter
extends AbstractRuleBasedConverter<DrdsTablePartition, ObMySql14xTablePartition> {
    private static final Map<String, String> PARTITION_TYPE_CONVERT_MAP = new HashMap<String, String>();
    private static final List<String> SUPPORTED_LEVEL1_PART_METHOD = Collections.singletonList("HASH");

    public PolarXDrdsObMysqlPartitionConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObMySql14xTablePartition convertByRule(DrdsTablePartition source) {
        AbstractDrdsPartition.Partition subPartition;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObMySql14xSchema schema = new ObMySql14xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getDbType());
        ObMySql14xTablePartition target = new ObMySql14xTablePartition(schema);
        target.setObjectName(source.getObjectName());
        AbstractDrdsPartition.Partition dbPartition = source.getDbPartition();
        AbstractDrdsPartition.Partition tablePartition = source.getTablePartition();
        AbstractDrdsPartition.Partition partition = dbPartition != null ? dbPartition : tablePartition;
        AbstractDrdsPartition.Partition partition2 = subPartition = partition != null && partition != tablePartition ? tablePartition : null;
        if (partition == null) {
            return target;
        }
        String originPartitionType = partition.getPartitionMethod();
        PartitionConvertStrategy partStrategy = DrdsPartitionConvertStrategyFactory.getPartitionStrategy(partition, subPartition, source.getColumnMapping());
        String partitionType = partStrategy.getConvertPartMethod();
        if (!partitionType.equals(originPartitionType)) {
            ChangeUtils.info(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, partition == dbPartition ? "DBPARTITION BY " : "TBPARTITION BY " + originPartitionType + partStrategy.enclosePartExpress() + " -> PARTITION BY " + partitionType + partStrategy.encloseConvertPartExpress());
        }
        target.setPartitionMethod(partitionType);
        target.setPartitionExpression(partStrategy.getConvertPartExpress());
        if (dbPartition != null) {
            target.setPartNum(dbPartition.getPartitionNum());
        }
        for (int i = 0; i < partition.getPartitionNum(); ++i) {
            AbstractMySqlTablePartition.MySqlPartitionItem targetItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
            targetItem.setPartitionName(partition.getNamePattern().replaceAll("\\{0+\\}", String.valueOf(i)));
            targetItem.setPartitionOrdinalPosition(i);
            targetItem.setPartitionDescription(String.valueOf(i));
            target.getTablePartitions().add(targetItem);
        }
        if (subPartition == null || SUPPORTED_LEVEL1_PART_METHOD.contains(originPartitionType) && subPartition.getPartitionMethod().equals(originPartitionType) && subPartition.getPartitionColumns().get(0).equals(partition.getPartitionColumns().get(0))) {
            target.setPartLevel(ObMySql14xTablePartition.PART_LEVEL_1);
            return target;
        }
        target.setPartLevel(ObMySql14xTablePartition.PART_LEVEL_2);
        String originSubPartitionType = subPartition.getPartitionMethod();
        PartitionConvertStrategy subPartStrategy = DrdsPartitionConvertStrategyFactory.getPartitionStrategy(subPartition, source.getColumnMapping());
        String subPartitionType = subPartStrategy.getConvertPartMethod();
        if (!subPartitionType.equals(originSubPartitionType)) {
            ChangeUtils.info(ObjectType.TABLE, target.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, "TBPARTITION BY " + originSubPartitionType + subPartStrategy.enclosePartExpress() + " -> PARTITION BY " + subPartitionType + subPartStrategy.encloseConvertPartExpress());
        }
        target.setSubPartitionMethod(subPartitionType);
        target.setSubPartitionExpression(subPartStrategy.getConvertPartExpress());
        target.setSubPartNum(subPartition.getPartitionNum());
        String namePattern = subPartition.getNamePattern().substring(0, subPartition.getNamePattern().lastIndexOf("_"));
        for (AbstractMySqlTablePartition.MySqlPartitionItem partitionItem : target.getTablePartitions()) {
            ArrayList<AbstractMySqlTablePartition.MySqlPartitionItem> subPartItems = new ArrayList<AbstractMySqlTablePartition.MySqlPartitionItem>();
            for (int i = 0; i < subPartition.getPartitionNum(); ++i) {
                AbstractMySqlTablePartition.MySqlPartitionItem subPartItem = new AbstractMySqlTablePartition.MySqlPartitionItem();
                subPartItem.setSubPartitionName(namePattern + i);
                subPartItem.setPartitionOrdinalPosition(i);
                subPartItem.setPartitionDescription(String.valueOf(i));
                subPartItems.add(subPartItem);
            }
            if ("LIST".equals(target.getSubPartitionMethod())) {
                target.getTableSubPartitionMapping().put(String.valueOf(-1), subPartItems);
                target.setSubPartTemplate(true);
                continue;
            }
            target.getTableSubPartitionMapping().put(partitionItem.getPartitionName(), subPartItems);
        }
        return target;
    }

    static {
        PARTITION_TYPE_CONVERT_MAP.put("UNI_HASH", "HASH");
    }
}

