/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.polarx.strategy;

import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.mapper.converter.polarx.strategy.PartitionConvertStrategy;
import com.oceanbase.obtools.dbdiff.mapper.converter.polarx.strategy.impl.DefaultPartitionConvertStrategy;
import com.oceanbase.obtools.dbdiff.mapper.converter.polarx.strategy.impl.HASHPartitionConvertStrategy;
import com.oceanbase.obtools.dbdiff.mapper.converter.polarx.strategy.impl.MMDDPartitionConvertStrategy;
import com.oceanbase.obtools.dbdiff.mapper.converter.polarx.strategy.impl.MMPartitionConvertStrategy;
import com.oceanbase.obtools.dbdiff.mapper.converter.polarx.strategy.impl.WEEKPartitionConvertStrategy;
import com.oceanbase.obtools.dbdiff.mapper.converter.polarx.strategy.impl.YYYYDDPartitionConvertStrategy;
import com.oceanbase.obtools.dbdiff.mapper.converter.polarx.strategy.impl.YYYYMMPartitionConvertStrategy;
import com.oceanbase.obtools.dbdiff.mapper.converter.polarx.strategy.impl.YYYYWEEKPartitionConvertStrategy;
import com.oceanbase.obtools.dbdiff.model.drds.AbstractDrdsPartition;
import com.oceanbase.obtools.dbdiff.model.drds.DrdsColumn;
import java.util.List;
import java.util.Map;

public class DrdsPartitionConvertStrategyFactory {
    public static PartitionConvertStrategy getPartitionStrategy(AbstractDrdsPartition.Partition partition, AbstractDrdsPartition.Partition subPartition, Map<String, DrdsColumn> columnMapping) {
        String partitionMethodName = partition.getPartitionMethod();
        List<String> partitionColumns = partition.getPartitionColumns();
        switch (partitionMethodName) {
            case "HASH": 
            case "UNI_HASH": {
                if (partitionMethodName.equals("HASH") && subPartition != null && subPartition.getPartitionMethod().equals(partitionMethodName) && CollectionUtils.isNotEmpty(partition.getPartitionColumns()) && CollectionUtils.isNotEmpty(subPartition.getPartitionColumns()) && partition.getPartitionColumns().get(0).equals(subPartition.getPartitionColumns().get(0))) {
                    partition.setPartitionNum(partition.getPartitionNum() * subPartition.getPartitionNum());
                }
                return new HASHPartitionConvertStrategy(columnMapping, partitionColumns);
            }
            case "MM": {
                return new MMPartitionConvertStrategy(partitionColumns);
            }
            case "MMDD": {
                return new MMDDPartitionConvertStrategy(partitionColumns);
            }
            case "WEEK": {
                return new WEEKPartitionConvertStrategy(partitionColumns);
            }
            case "YYYYDD": 
            case "YYYYDD_OPT": {
                return new YYYYDDPartitionConvertStrategy(partitionColumns);
            }
            case "YYYYWEEK": 
            case "YYYYWEEK_OPT": {
                return new YYYYWEEKPartitionConvertStrategy(partitionColumns, partition.getPartitionNum());
            }
            case "YYYYMM": 
            case "YYYYMM_OPT": {
                return new YYYYMMPartitionConvertStrategy(partitionColumns, partition);
            }
        }
        return new DefaultPartitionConvertStrategy(partitionColumns, partition);
    }

    public static PartitionConvertStrategy getPartitionStrategy(AbstractDrdsPartition.Partition partition, Map<String, DrdsColumn> columnMapping) {
        return DrdsPartitionConvertStrategyFactory.getPartitionStrategy(partition, null, columnMapping);
    }
}

