/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.sybase;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xColumn;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseColumn;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

@Conversion(sourceDbType=DbType.SYBASE_12, targetDbType=DbType.OBORACLE_22)
public class SybaseaseObOracle22xColumnConverter
extends AbstractRuleBasedConverter<SybaseaseColumn, ObOracle22xColumn> {
    private static final Map<String, ColumnDef> DATA_TYPE_MAPPING = new HashMap<String, ColumnDef>();

    public SybaseaseObOracle22xColumnConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xColumn convertByRule(SybaseaseColumn source) {
        String dataType;
        String upperType;
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xColumn column = new ObOracle22xColumn(schema);
        column.setObjectName(source.getObjectName());
        column.setColumnName(source.getColumnName());
        if ("YES".equalsIgnoreCase(source.getNullable())) {
            column.setNullable("Y");
        } else if ("NO".equalsIgnoreCase(source.getNullable())) {
            column.setNullable("N");
        }
        column.setColumnComment(source.getColumnComment());
        column.setOrdinalPosition(source.getOrdinalPosition());
        String computeExpr = source.getComputeExpr();
        if (StringUtils.isNotBlank((CharSequence)computeExpr)) {
            column.setVirtualColumn("YES");
            int beginIndex = computeExpr.indexOf(40);
            int endIndex = computeExpr.lastIndexOf(41);
            if (beginIndex > -1 && endIndex > -1) {
                computeExpr = computeExpr.substring(beginIndex + 1, endIndex);
            }
            column.setColumnDefault(computeExpr.replaceAll("\\s*AS\\s+", "").trim());
        }
        if ("NUMERIC IDENTITY".equals(upperType = (dataType = source.getDataType()).trim().toUpperCase(Locale.getDefault()))) {
            ChangeUtils.warn(ObjectType.TABLE, column.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, column.getWrappedName() + " identity -> " + column.getWrappedName() + " [NULL]", "-- If necessary, use the CREATE SEQUENCE statement instead of it");
        }
        ColumnDef def = null;
        switch (upperType) {
            case "TEXT": 
            case "UNITEXT": {
                if (source.getLength() < 4000L) {
                    def = new ColumnDef("VARCHAR2", source.getLength());
                    break;
                }
                def = new ColumnDef("CLOB", source.getLength());
                break;
            }
            case "VARBINARY": {
                if (source.getLength() < 255L) {
                    def = new ColumnDef("RAW", source.getLength());
                    break;
                }
                def = new ColumnDef("BLOB", source.getLength());
                break;
            }
            case "IMAGE": {
                if (source.getLength() < 2000L) {
                    def = new ColumnDef("RAW", source.getLength());
                    break;
                }
                def = new ColumnDef("BLOB", source.getLength());
                break;
            }
            case "CHAR": 
            case "NCHAR": 
            case "UNICHAR": {
                def = DATA_TYPE_MAPPING.getOrDefault(upperType, new ColumnDef(upperType, source.getLength()));
                column.setCharLength(source.getLength());
                column.setCharUsed("B");
                break;
            }
            case "VARCHAR": 
            case "NVARCHAR": 
            case "UNIVARCHAR": {
                def = DATA_TYPE_MAPPING.getOrDefault(upperType, new ColumnDef(upperType, source.getLength()));
                column.setCharLength(source.getLength());
                column.setCharUsed("B");
                break;
            }
            default: {
                def = DATA_TYPE_MAPPING.getOrDefault(upperType, new ColumnDef(upperType, source.getLength(), source.getPrec(), source.getScale()));
            }
        }
        column.setDataType(def.getDataType());
        column.setDataLength(def.getLength());
        column.setDataPrecision(def.getPrecision());
        column.setDataScale(def.getScale());
        try {
            ChangeUtils.warn(ObjectType.TABLE, source.getSchemaObjectName(), ChangeInfo.ChangeType.CONVERT, source.buildGrammar() + " -> " + column.buildGrammar());
        }
        catch (UnsupportedGrammarException unsupportedGrammarException) {
            // empty catch block
        }
        return column;
    }

    static {
        DATA_TYPE_MAPPING.put("BIGINT", new ColumnDef("NUMBER", 19, -1));
        DATA_TYPE_MAPPING.put("INT", new ColumnDef("NUMBER", 10, -1));
        DATA_TYPE_MAPPING.put("SMALLINT", new ColumnDef("NUMBER", 5, -1));
        DATA_TYPE_MAPPING.put("TINYINT", new ColumnDef("NUMBER", 3, -1));
        DATA_TYPE_MAPPING.put("UNSIGNED BIGINT", new ColumnDef("NUMBER", 20, -1));
        DATA_TYPE_MAPPING.put("UNSIGNED INT", new ColumnDef("NUMBER", 10, -1));
        DATA_TYPE_MAPPING.put("UNSIGNED SMALLINT", new ColumnDef("NUMBER", 5, -1));
        DATA_TYPE_MAPPING.put("FLOAT", new ColumnDef("FLOAT", 53, -1));
        DATA_TYPE_MAPPING.put("DOUBLE", new ColumnDef("BINARY_DOUBLE"));
        DATA_TYPE_MAPPING.put("REAL", new ColumnDef("FLOAT", 24, -1));
        DATA_TYPE_MAPPING.put("SMALLMONEY", new ColumnDef("NUMBER", 10, 4));
        DATA_TYPE_MAPPING.put("MONEY", new ColumnDef("NUMBER", 19, 4));
        DATA_TYPE_MAPPING.put("SMALLDATETIME", new ColumnDef("DATE"));
        DATA_TYPE_MAPPING.put("DATETIME", new ColumnDef("DATE"));
        DATA_TYPE_MAPPING.put("DATE", new ColumnDef("DATE"));
        DATA_TYPE_MAPPING.put("TIME", new ColumnDef("CHAR", 15L));
        DATA_TYPE_MAPPING.put("BIGDATETIME", new ColumnDef("TIMESTAMP"));
        DATA_TYPE_MAPPING.put("BIGTIME", new ColumnDef("CHAR", 15L));
        DATA_TYPE_MAPPING.put("BIT", new ColumnDef("NUMBER", 3, -1));
    }

    static class ColumnDef {
        private static final Map<String, String> INNER_DATA_TYPE_MAPPING = new HashMap<String, String>();
        private final String dataType;
        private final long length;
        private final int precision;
        private final int scale;

        public ColumnDef(String dataType) {
            this(dataType, -1L, -1, -1);
        }

        public ColumnDef(String dataType, long length) {
            this(dataType, length, -1, -1);
        }

        public ColumnDef(String dataType, int precision, int scale) {
            this(dataType, -1L, precision, scale);
        }

        public ColumnDef(String dataType, long length, int precision, int scale) {
            this.dataType = dataType;
            this.length = length;
            this.precision = precision;
            this.scale = scale;
        }

        public String getDataType() {
            return INNER_DATA_TYPE_MAPPING.getOrDefault(this.dataType, this.dataType);
        }

        public long getLength() {
            return this.length;
        }

        public int getPrecision() {
            return this.precision;
        }

        public int getScale() {
            return this.scale;
        }

        static {
            INNER_DATA_TYPE_MAPPING.put("BINARY", "RAW");
            INNER_DATA_TYPE_MAPPING.put("CHAR", "CHAR");
            INNER_DATA_TYPE_MAPPING.put("NCHAR", "NCHAR");
            INNER_DATA_TYPE_MAPPING.put("UNICHAR", "NCHAR");
            INNER_DATA_TYPE_MAPPING.put("VARCHAR", "VARCHAR2");
            INNER_DATA_TYPE_MAPPING.put("NVARCHAR", "NVARCHAR2");
            INNER_DATA_TYPE_MAPPING.put("UNIVARCHAR", "NVARCHAR2");
            INNER_DATA_TYPE_MAPPING.put("NUMERIC IDENTITY", "NUMBER");
        }
    }
}

