/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.converter.sybase;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.compare.result.ChangeInfo;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.enums.DbType;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.mapper.Conversion;
import com.oceanbase.obtools.dbdiff.mapper.converter.AbstractRuleBasedConverter;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xSchema;
import com.oceanbase.obtools.dbdiff.model.oboracle22x.ObOracle22xTablePartition;
import com.oceanbase.obtools.dbdiff.model.oracle.AbstractOracleTablePartition;
import com.oceanbase.obtools.dbdiff.model.sybasease.SybaseaseTablePartition;
import com.oceanbase.obtools.dbdiff.rules.RuleContext;
import com.oceanbase.obtools.dbdiff.utils.ChangeUtils;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Conversion(sourceDbType=DbType.SYBASE_12, targetDbType=DbType.OBORACLE_22)
public class SybaseaseObOracle22xPartitionConverter
extends AbstractRuleBasedConverter<SybaseaseTablePartition, ObOracle22xTablePartition> {
    public SybaseaseObOracle22xPartitionConverter(RuleContext ruleContext) {
        super(ruleContext);
    }

    @Override
    public ObOracle22xTablePartition convertByRule(SybaseaseTablePartition source) {
        String partitionType = source.getPartitionType().toUpperCase(Locale.getDefault());
        if ("ROUNDROBIN".equalsIgnoreCase(partitionType)) {
            ChangeUtils.info(ObjectType.TABLE, source.getSchemaObjectName(), ChangeInfo.ChangeType.DISCARD, ".... partition by " + partitionType + " -> NULL");
            return null;
        }
        Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> columns = this.splitPartitionKeys(source.getPartitionKeys());
        Global global = source.getGlobal();
        DbType dbType = source.getDbType();
        String schemaName = source.getSchemaName();
        ObOracle22xSchema schema = new ObOracle22xSchema(global, dbType, schemaName);
        schema.setOriginDbType(source.getOriginDbType());
        ObOracle22xTablePartition partition = new ObOracle22xTablePartition(schema);
        partition.setObjectName(source.getObjectName());
        partition.setPartitioningType(partitionType);
        partition.setPartitioningKeyCount(columns.size());
        partition.getTablePartitionColumns().addAll(columns);
        if ("HASH".equalsIgnoreCase(partitionType)) {
            partition.setPartitionCount(source.getPartitions());
            return partition;
        }
        for (SybaseaseTablePartition.SybaseaseTablePartitionItem origin : source.getPartitionItems()) {
            AbstractOracleTablePartition.OracleTablePartitionItem partitionItem = new AbstractOracleTablePartition.OracleTablePartitionItem();
            partitionItem.setPartitionName(origin.getPartitionName());
            partitionItem.setHighValue(this.parsePartitionExpr(source.getSchemaObjectName(), origin.getPartitionExpr()));
            partitionItem.setPartitionPosition(origin.getPartitionPosition());
            partition.getTablePartitions().add(partitionItem);
        }
        return partition;
    }

    private String parsePartitionExpr(String objectName, String partitionExpr) {
        if (StringUtils.isBlank((CharSequence)partitionExpr)) {
            return partitionExpr;
        }
        int beginIndex = partitionExpr.indexOf(40);
        int endIndex = partitionExpr.lastIndexOf(41);
        if (beginIndex > -1 && endIndex > -1) {
            String newExpr = partitionExpr.substring(beginIndex + 1, endIndex).trim();
            String regex = "\\s*max\\s*(,\\s*max)*\\s*";
            if (Pattern.compile(regex, 2).matcher(newExpr).matches()) {
                newExpr = newExpr.toUpperCase(Locale.getDefault()).replaceAll("MAX", "MAXVALUE");
            }
            ChangeUtils.info(ObjectType.TABLE, objectName, ChangeInfo.ChangeType.CONVERT, partitionExpr + " -> VALUES LESS THAN (" + newExpr + ")");
            return newExpr;
        }
        return partitionExpr;
    }

    private Collection<AbstractOracleTablePartition.OracleTablePartitionColumn> splitPartitionKeys(String partitionKeys) {
        if (partitionKeys == null) {
            throw new IllegalArgumentException("The partitionKeys keys is null");
        }
        if (partitionKeys.contains(",")) {
            return Stream.of(partitionKeys.split(",")).map(e -> new AbstractOracleTablePartition.OracleTablePartitionColumn((String)e)).collect(Collectors.toList());
        }
        return Lists.newArrayList((Object[])new AbstractOracleTablePartition.OracleTablePartitionColumn[]{new AbstractOracleTablePartition.OracleTablePartitionColumn(partitionKeys)});
    }
}

