/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.mapper.expression.pgsql;

import com.alipay.oceanbase.g4.postgresql.PostgreSQLStatementBaseListener;
import com.alipay.oceanbase.g4.postgresql.PostgreSQLStatementParser;
import com.oceanbase.obtools.dbdiff.configure.Global;
import com.oceanbase.obtools.dbdiff.mapper.expression.AbstractAntlrExpressionRewriter;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.TokenStreamRewriter;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresExpressionRewriter
extends AbstractAntlrExpressionRewriter {
    private static final Logger log = LoggerFactory.getLogger(PostgresExpressionRewriter.class);

    public PostgresExpressionRewriter(Global global) {
        super(global);
    }

    @Override
    public String rewriteCheckExpr(String text) {
        Rewriter rewriter = new Rewriter(text);
        return rewriter.rewrite("checkOption");
    }

    @Override
    public String rewriteIndexExpr(String text) {
        Rewriter rewriter = new Rewriter(text);
        return rewriter.rewrite("indexElem");
    }

    public class Rewriter
    extends PostgreSQLStatementBaseListener {
        private final String text;
        private final TokenStream tokenStream;
        private final TokenStreamRewriter rewriter;

        public Rewriter(String text) {
            this.text = text;
            this.tokenStream = PostgresExpressionRewriter.this.tokenStream(text);
            this.rewriter = new TokenStreamRewriter(this.tokenStream);
        }

        public String rewrite(String enterPoint) {
            try {
                PostgreSQLStatementParser parser = new PostgreSQLStatementParser(this.tokenStream);
                ParseTree parseTree = PostgresExpressionRewriter.this.invoke((Parser)parser, enterPoint);
                ParseTreeWalker.DEFAULT.walk((ParseTreeListener)this, parseTree);
                return this.rewriter.getText();
            }
            catch (Exception e) {
                log.error("Failed to rewrite [{}]", (Object)this.text, (Object)e);
                return this.text;
            }
        }

        public void enterColumnref(PostgreSQLStatementParser.ColumnrefContext ctx) {
            if (PostgresExpressionRewriter.this.global.withQuota()) {
                this.rewriter.insertBefore(ctx.getStart(), (Object)"\"");
                this.rewriter.insertAfter(ctx.getStop(), (Object)"\"");
            }
            this.rewriter.replace(ctx.getStart(), (Object)PostgresExpressionRewriter.this.global.getColumnCase().apply(ctx.getText()));
        }

        public void enterAExpr(PostgreSQLStatementParser.AExprContext ctx) {
            if (ctx.TYPE_CAST_() != null && ctx.typeName() != null) {
                this.rewriter.replace(ctx.TYPE_CAST_().getSymbol(), (Object)"");
                this.rewriter.replace(ctx.typeName().start, ctx.typeName().stop, (Object)"");
                for (PostgreSQLStatementParser.AExprContext aExprContext : ctx.aExpr()) {
                    PostgreSQLStatementParser.CExprContext cExprContext = aExprContext.cExpr();
                    if (cExprContext == null || cExprContext.LP_() == null || cExprContext.RP_() == null) continue;
                    this.rewriter.delete(cExprContext.LP_().getSymbol());
                    this.rewriter.delete(cExprContext.RP_().getSymbol());
                }
            }
        }
    }
}

