/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model;

import com.oceanbase.obtools.dbdiff.comparator.IComparable;
import com.oceanbase.obtools.dbdiff.compare.result.AlterObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractOwnership;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.base.IGrammar;
import java.util.Objects;

public abstract class AbstractColumn
extends AbstractOwnership
implements IGrammar,
IComparable<AbstractColumn> {
    private String columnName;
    private String dataType;
    private long ordinalPosition;
    private String columnDefault;
    private String nullable;
    private String columnComment;

    public AbstractColumn(AbstractSchema schema) {
        super(schema);
    }

    public String getWrappedName() {
        return this.wrap(this.getColumnName());
    }

    public String getGrammarColumnName() {
        return this.getGlobal().getColumnCase().apply(this.wrap(this.getColumnName()));
    }

    public ObjectDefine buildAddDefinition() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER TABLE ").append(this.getSchemaObjectName());
            sb.append(" ADD COLUMN ").append((CharSequence)this.buildGrammar()).append(";");
            return new AlterObjectDefine(ObjectType.COLUMN, this.getSimpleObjectName(), sb.toString());
        }
        catch (UnsupportedGrammarException e) {
            return new UnsupportedObjectDefine(ObjectType.COLUMN, this.getSimpleObjectName(), e.getMessage());
        }
    }

    public ObjectDefine buildDropDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(this.getSchemaObjectName());
        sb.append(" DROP COLUMN ").append(this.getWrappedName()).append(";");
        return new DropObjectDefine(ObjectType.COLUMN, this.getSimpleObjectName(), sb.toString());
    }

    public String escapeColumnDefault(String colDefault) {
        if (colDefault.startsWith("'") && colDefault.endsWith("'") && colDefault.length() > 1) {
            colDefault = colDefault.substring(1, colDefault.length() - 1).replace("'", "''");
            return "'" + colDefault + "'";
        }
        return colDefault;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.columnName, this.ordinalPosition);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractColumn)) {
            return false;
        }
        AbstractColumn other = (AbstractColumn)obj;
        return Objects.equals(this.columnName, other.columnName) && Objects.equals(this.ordinalPosition, other.ordinalPosition);
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public long getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public void setOrdinalPosition(long ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    public String getColumnDefault() {
        return this.columnDefault;
    }

    public void setColumnDefault(String columnDefault) {
        this.columnDefault = columnDefault;
    }

    public String getNullable() {
        return this.nullable;
    }

    public void setNullable(String nullable) {
        this.nullable = nullable;
    }

    public String getColumnComment() {
        return this.columnComment;
    }

    public void setColumnComment(String columnComment) {
        this.columnComment = columnComment;
    }
}

