/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model;

import com.oceanbase.obtools.common.utils.StringUtils;
import com.oceanbase.obtools.dbdiff.comparator.IComparable;
import com.oceanbase.obtools.dbdiff.compare.result.AlterObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractOwnership;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.base.IGrammar;
import com.oceanbase.obtools.dbdiff.model.base.KeyColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractConstraint
extends AbstractOwnership
implements IGrammar,
IComparable<AbstractConstraint> {
    public static final Map<String, String> DELETE_RULE_MAPPING = new HashMap<String, String>();
    public static final Map<String, String> UPDATE_RULE_MAPPING;
    private String constraintSchema;
    private String constraintName;
    private String constraintType;
    private String refTableOwner;
    private String refTableName;
    private String deleteRule;
    private String updateRule;
    private String comment;
    private final List<KeyColumn> constraintColumns = new ArrayList<KeyColumn>();
    private final List<KeyColumn> foreignColumns = new ArrayList<KeyColumn>();
    private final List<KeyColumn> referencedColumns = new ArrayList<KeyColumn>();

    public AbstractConstraint(AbstractSchema schema) {
        super(schema);
    }

    protected String getRefOwnerTableName() throws UnsupportedGrammarException {
        StringBuilder sb = new StringBuilder();
        if (super.getGlobal().withSchema() || !this.getSchemaName().equals(this.getRefTableOwner())) {
            sb.append(this.wrapAndCase(this.getRefTableOwner(), "schemaCase")).append(".");
        }
        return sb.append(this.wrapAndCase(this.getRefTableName(), "tableCase")).toString();
    }

    public StringBuilder joinConstraintColumns() {
        return this.enclose(this.getConstraintColumns().stream().map(e -> {
            String wrapped = this.wrapAndCase(e.getColumnName(), "columnCase");
            String subPart = e.getSubPart();
            if (StringUtils.isNotBlank((CharSequence)subPart)) {
                wrapped = wrapped + "(" + subPart + ")";
            }
            return wrapped;
        }).collect(Collectors.joining(", ")));
    }

    public StringBuilder joinForeignConstraintColumns() {
        return this.enclose(this.getForeignColumns().stream().map(e -> this.wrapAndCase(e.getColumnName(), "columnCase")).collect(Collectors.joining(", ")));
    }

    public StringBuilder joinRefConstraintColumns() {
        return this.enclose(this.getReferencedColumns().stream().map(e -> this.wrapAndCase(e.getColumnName(), "columnCase")).collect(Collectors.joining(", ")));
    }

    public String buildUniqueReference() {
        StringBuilder key = new StringBuilder();
        key.append((CharSequence)this.joinForeignConstraintColumns());
        key.append(this.wrapAndCase(this.getRefTableOwner(), "schemaCase")).append(".").append(this.wrapAndCase(this.getRefTableName(), "tableCase"));
        return key.append((CharSequence)this.joinRefConstraintColumns()).toString();
    }

    public ObjectDefine buildAddDefinition() {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER TABLE ").append(this.getSchemaObjectName());
            sb.append(" ADD ").append((CharSequence)this.buildGrammar()).append(";");
            return new AlterObjectDefine(ObjectType.CONSTRAINT, this.getSimpleObjectName(), sb.toString());
        }
        catch (UnsupportedGrammarException e) {
            return new UnsupportedObjectDefine(ObjectType.CONSTRAINT, this.getSimpleObjectName(), e.getMessage());
        }
    }

    public ObjectDefine buildDropDefinition() {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(this.getSchemaObjectName());
        sb.append(" DROP CONSTRAINT ").append(this.wrap(this.getConstraintName())).append(";");
        return new DropObjectDefine(ObjectType.CONSTRAINT, this.getSimpleObjectName(), sb.toString());
    }

    public ObjectDefine buildRenameDefinition(String dstConstraintName, String schemaName) {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(this.getSchemaObjectName()).append(" RENAME CONSTRAINT ");
        sb.append(this.wrap(this.getConstraintName())).append(" TO ").append(this.wrap(dstConstraintName)).append(";");
        return new DropObjectDefine(ObjectType.CONSTRAINT, this.getSimpleObjectName(), sb.toString());
    }

    public String getConstraintSchema() {
        return this.constraintSchema;
    }

    public void setConstraintSchema(String constraintSchema) {
        this.constraintSchema = constraintSchema;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public String getConstraintType() {
        return this.constraintType;
    }

    public void setConstraintType(String constraintType) {
        this.constraintType = constraintType;
    }

    public String getRefTableOwner() {
        return this.refTableOwner;
    }

    public void setRefTableOwner(String refTableOwner) {
        this.refTableOwner = refTableOwner;
    }

    public String getRefTableName() {
        return this.refTableName;
    }

    public void setRefTableName(String refTableName) {
        this.refTableName = refTableName;
    }

    public String getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(String deleteRule) {
        this.deleteRule = deleteRule;
    }

    public String getUpdateRule() {
        return this.updateRule;
    }

    public void setUpdateRule(String updateRule) {
        this.updateRule = updateRule;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<KeyColumn> getConstraintColumns() {
        return this.constraintColumns;
    }

    public List<KeyColumn> getForeignColumns() {
        return this.foreignColumns;
    }

    public List<KeyColumn> getReferencedColumns() {
        return this.referencedColumns;
    }

    static {
        DELETE_RULE_MAPPING.put("C", " ON DELETE CASCADE");
        DELETE_RULE_MAPPING.put("N", " ON DELETE SET NULL");
        DELETE_RULE_MAPPING.put("R", " ON DELETE RESTRICT");
        DELETE_RULE_MAPPING.put("CASCADE", " ON DELETE CASCADE");
        DELETE_RULE_MAPPING.put("SET NULL", " ON DELETE SET NULL");
        DELETE_RULE_MAPPING.put("RESTRICT", " ON DELETE RESTRICT");
        DELETE_RULE_MAPPING.put("SET DEFAULT", " ON DELETE SET DEFAULT");
        UPDATE_RULE_MAPPING = new HashMap<String, String>();
        UPDATE_RULE_MAPPING.put("R", " ON UPDATE RESTRICT");
        UPDATE_RULE_MAPPING.put("CASCADE", " ON UPDATE CASCADE");
        UPDATE_RULE_MAPPING.put("SET NULL", " ON UPDATE SET NULL");
        UPDATE_RULE_MAPPING.put("RESTRICT", " ON UPDATE RESTRICT");
        UPDATE_RULE_MAPPING.put("SET DEFAULT", " ON UPDATE SET DEFAULT");
    }
}

