/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model;

import com.oceanbase.obtools.common.collect.Lists;
import com.oceanbase.obtools.common.collect.Maps;
import com.oceanbase.obtools.common.utils.ClassUtils;
import com.oceanbase.obtools.common.utils.CollectionUtils;
import com.oceanbase.obtools.dbdiff.compare.result.DropObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.ObjectDefine;
import com.oceanbase.obtools.dbdiff.compare.result.UnsupportedObjectDefine;
import com.oceanbase.obtools.dbdiff.enums.ObjectType;
import com.oceanbase.obtools.dbdiff.exception.UnmatchedObjectTypeException;
import com.oceanbase.obtools.dbdiff.exception.UnsupportedGrammarException;
import com.oceanbase.obtools.dbdiff.model.AbstractCursor;
import com.oceanbase.obtools.dbdiff.model.AbstractDatabaseLink;
import com.oceanbase.obtools.dbdiff.model.AbstractDependency;
import com.oceanbase.obtools.dbdiff.model.AbstractEvent;
import com.oceanbase.obtools.dbdiff.model.AbstractFunction;
import com.oceanbase.obtools.dbdiff.model.AbstractJob;
import com.oceanbase.obtools.dbdiff.model.AbstractMaterializedView;
import com.oceanbase.obtools.dbdiff.model.AbstractOwnership;
import com.oceanbase.obtools.dbdiff.model.AbstractPackage;
import com.oceanbase.obtools.dbdiff.model.AbstractPackageBody;
import com.oceanbase.obtools.dbdiff.model.AbstractProcedure;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;
import com.oceanbase.obtools.dbdiff.model.AbstractSequence;
import com.oceanbase.obtools.dbdiff.model.AbstractSynonym;
import com.oceanbase.obtools.dbdiff.model.AbstractTable;
import com.oceanbase.obtools.dbdiff.model.AbstractTableGroup;
import com.oceanbase.obtools.dbdiff.model.AbstractTablespace;
import com.oceanbase.obtools.dbdiff.model.AbstractTrigger;
import com.oceanbase.obtools.dbdiff.model.AbstractType;
import com.oceanbase.obtools.dbdiff.model.AbstractTypeBody;
import com.oceanbase.obtools.dbdiff.model.AbstractView;
import com.oceanbase.obtools.dbdiff.model.base.IDefiner;
import com.oceanbase.obtools.dbdiff.model.relation.ObjectRelationGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabase
extends AbstractOwnership
implements IDefiner {
    private static final Logger log = LoggerFactory.getLogger(AbstractDatabase.class);

    public AbstractDatabase(AbstractSchema schema) {
        super(schema);
    }

    public boolean isTablespaceSupported() {
        return true;
    }

    public boolean isTableGroupSupported() {
        return true;
    }

    public boolean isSequenceSupported() {
        return true;
    }

    public boolean isAliasSupported() {
        return true;
    }

    public boolean isTriggerSupported() {
        return true;
    }

    public boolean isDbLinkSupported() {
        return true;
    }

    public boolean isSynonymSupported() {
        return true;
    }

    public boolean isFunctionSupported() {
        return true;
    }

    public boolean isProcedureSupported() {
        return true;
    }

    public boolean isTypeSupported() {
        return true;
    }

    public boolean isTypeBodySupported() {
        return true;
    }

    public boolean isPackageSupported() {
        return true;
    }

    public boolean isPackageBodySupported() {
        return true;
    }

    public boolean isMaterializedViewSupported() {
        return true;
    }

    public Class<? extends IDefiner> resolveObjectClass(ObjectType objectType) {
        switch (objectType) {
            case TABLE: {
                return this.resolveTableClass();
            }
            case VIEW: {
                return this.resolveViewClass();
            }
        }
        throw new UnmatchedObjectTypeException("Unsupported resolve object type: " + (Object)((Object)objectType));
    }

    public Class<? extends AbstractSchema> resolveSchemaClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractTablespace> resolveTablespaceClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractTableGroup> resolveTableGroupClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractTable> resolveTableClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractView> resolveViewClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractSequence> resolveSequenceClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractTrigger> resolveTriggerClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractFunction> resolveFunctionClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractProcedure> resolveProcedureClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractSynonym> resolveAliasClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractSynonym> resolveSynonymClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractDatabaseLink> resolveDbLinkClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractMaterializedView> resolveMviewClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractType> resolveTypeClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractTypeBody> resolveTypeBodyClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractPackage> resolvePackageClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public Class<? extends AbstractPackageBody> resolvePackageBodyClass() {
        throw new UnsupportedOperationException("Not Implement");
    }

    public AbstractTablespace acquireTablespace(String tablespaceName) {
        return this.acquireTablespaceMapping().get(tablespaceName);
    }

    public AbstractTableGroup acquireTableGroup(String tableGroupName) {
        return this.acquireTableGroupMapping().get(tableGroupName);
    }

    public AbstractTable acquireTable(String tableName) {
        return this.acquireTableMapping().get(tableName);
    }

    public AbstractView acquireView(String viewName) {
        return this.acquireViewMapping().get(viewName);
    }

    public AbstractMaterializedView acquireMview(String mviewName) {
        return this.acquireMviewMapping().get(mviewName);
    }

    public AbstractSequence acquireSequence(String sequenceName) {
        return this.acquireSequenceMapping().get(sequenceName);
    }

    public AbstractTrigger acquireTrigger(String triggerName) {
        return this.acquireTriggerMapping().get(triggerName);
    }

    public AbstractFunction acquireFunction(String functionName) {
        return this.acquireFunctionMapping().get(functionName);
    }

    public AbstractProcedure acquireProcedure(String procedureName) {
        return this.acquireProcedureMapping().get(procedureName);
    }

    public AbstractSynonym acquireAlias(String aliasName) {
        return this.acquireAliasMapping().get(aliasName);
    }

    public AbstractSynonym acquireSynonym(String synonymName) {
        return this.acquireSynonymMapping().get(synonymName);
    }

    public AbstractDatabaseLink acquireDbLink(String dbLinkName) {
        return this.acquireDbLinkMapping().get(dbLinkName);
    }

    public AbstractType acquireType(String typeName) {
        return this.acquireTypeMapping().get(typeName);
    }

    public AbstractTypeBody acquireTypeBody(String typeBodyName) {
        return this.acquireTypeBodyMapping().get(typeBodyName);
    }

    public AbstractPackage acquirePackage(String packageName) {
        return this.acquirePackageMapping().get(packageName);
    }

    public AbstractPackageBody acquirePackageBody(String packageBodyName) {
        return this.acquirePackageBodyMapping().get(packageBodyName);
    }

    public List<? extends AbstractDependency> acquireDependencies() {
        log.debug("{} does't implement acquireDependencies()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Lists.newArrayList((Object[])new AbstractDependency[0]);
    }

    public Map<String, ? extends AbstractTablespace> acquireTablespaceMapping() {
        log.debug("{} does't implement acquireTablespaceMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractView> acquireViewMapping() {
        log.debug("{} does't implement acquireViewMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractTableGroup> acquireTableGroupMapping() {
        log.debug("{} does't implement acquireTableGroupMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractTable> acquireTableMapping() {
        log.debug("{} does't implement acquireTableMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractJob> acquireJobMapping() {
        log.debug("{} does't implement acquireJobMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractEvent> acquireEventMapping() {
        log.debug("{} does't implement acquireEventMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractCursor> acquireCursorMapping() {
        log.debug("{} does't implement acquireCursorMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractSynonym> acquireAliasMapping() {
        log.debug("{} does't implement acquireAliasMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractSynonym> acquireSynonymMapping() {
        log.debug("{} does't implement acquireSynonymMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractTrigger> acquireTriggerMapping() {
        log.debug("{} does't implement acquireTriggerMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractSequence> acquireSequenceMapping() {
        log.debug("{} does't implement acquireSequenceMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractFunction> acquireFunctionMapping() {
        log.debug("{} does't implement acquireFunctionMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractProcedure> acquireProcedureMapping() {
        log.debug("{} does't implement acquireProcedureMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractDatabaseLink> acquireDbLinkMapping() {
        log.debug("{} does't implement acquireDatabaseLinkMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractMaterializedView> acquireMviewMapping() {
        log.debug("{} does't implement acquireMaterializedViewMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractType> acquireTypeMapping() {
        log.debug("{} does't implement acquireTypeMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractTypeBody> acquireTypeBodyMapping() {
        log.debug("{} does't implement acquireTypeBodyMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractPackage> acquirePackageMapping() {
        log.debug("{} does't implement acquirePackageMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    public Map<String, ? extends AbstractPackageBody> acquirePackageBodyMapping() {
        log.debug("{} does't implement acquirePackageBodyMapping()", (Object)ClassUtils.getAbbreviatedName(this.getClass()));
        return Maps.newLinkedHashMap();
    }

    @Override
    public List<ObjectDefine> buildDefinition() throws UnsupportedGrammarException {
        super.getSchema().setDumpOperation(true);
        ArrayList<ObjectDefine> objectDefines = new ArrayList<ObjectDefine>();
        for (AbstractTablespace abstractTablespace : this.acquireTablespaceMapping().values()) {
            try {
                CollectionUtils.addAllIgnoreNull(objectDefines, abstractTablespace.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.TABLESPACE, abstractTablespace.getObjectName(), e.getMessage()));
            }
        }
        for (AbstractTable abstractTable : this.acquireTableMapping().values()) {
            try {
                CollectionUtils.addAllIgnoreNull(objectDefines, abstractTable.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.TABLE, abstractTable.getObjectName(), e.getMessage()));
            }
        }
        for (AbstractSequence abstractSequence : this.acquireSequenceMapping().values()) {
            try {
                CollectionUtils.addAllIgnoreNull(objectDefines, abstractSequence.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.SEQUENCE, abstractSequence.getObjectName(), e.getMessage()));
            }
        }
        for (AbstractView abstractView : this.acquireViewMapping().values()) {
            try {
                CollectionUtils.addAllIgnoreNull(objectDefines, abstractView.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.VIEW, abstractView.getObjectName(), e.getMessage()));
            }
        }
        for (AbstractMaterializedView abstractMaterializedView : this.acquireMviewMapping().values()) {
            try {
                CollectionUtils.addAllIgnoreNull(objectDefines, abstractMaterializedView.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.MVIEW, abstractMaterializedView.getObjectName(), e.getMessage()));
            }
        }
        for (AbstractSynonym abstractSynonym : this.acquireAliasMapping().values()) {
            try {
                CollectionUtils.addAllIgnoreNull(objectDefines, abstractSynonym.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.ALIAS, abstractSynonym.getObjectName(), e.getMessage()));
            }
        }
        for (AbstractSynonym abstractSynonym : this.acquireSynonymMapping().values()) {
            try {
                CollectionUtils.addAllIgnoreNull(objectDefines, abstractSynonym.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.SYNONYM, abstractSynonym.getObjectName(), e.getMessage()));
            }
        }
        for (AbstractType abstractType : this.acquireTypeMapping().values()) {
            try {
                CollectionUtils.addAllIgnoreNull(objectDefines, abstractType.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.TYPE, abstractType.getObjectName(), e.getMessage()));
            }
        }
        for (AbstractTypeBody abstractTypeBody : this.acquireTypeBodyMapping().values()) {
            try {
                CollectionUtils.addAllIgnoreNull(objectDefines, abstractTypeBody.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.TYPE_BODY, abstractTypeBody.getObjectName(), e.getMessage()));
            }
        }
        for (AbstractPackage abstractPackage : this.acquirePackageMapping().values()) {
            try {
                CollectionUtils.addAllIgnoreNull(objectDefines, abstractPackage.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.PACKAGE, abstractPackage.getObjectName(), e.getMessage()));
            }
        }
        for (AbstractPackageBody abstractPackageBody : this.acquirePackageBodyMapping().values()) {
            try {
                CollectionUtils.addAllIgnoreNull(objectDefines, abstractPackageBody.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.PACKAGE_BODY, abstractPackageBody.getObjectName(), e.getMessage()));
            }
        }
        for (AbstractTrigger abstractTrigger : this.acquireTriggerMapping().values()) {
            try {
                CollectionUtils.addAllIgnoreNull(objectDefines, abstractTrigger.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.TRIGGER, abstractTrigger.getObjectName(), e.getMessage()));
            }
        }
        for (AbstractProcedure abstractProcedure : this.acquireProcedureMapping().values()) {
            try {
                CollectionUtils.addAllIgnoreNull(objectDefines, abstractProcedure.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.PROCEDURE, abstractProcedure.getObjectName(), e.getMessage()));
            }
        }
        for (AbstractFunction abstractFunction : this.acquireFunctionMapping().values()) {
            try {
                CollectionUtils.addAllIgnoreNull(objectDefines, abstractFunction.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.FUNCTION, abstractFunction.getObjectName(), e.getMessage()));
            }
        }
        for (AbstractDatabaseLink abstractDatabaseLink : this.acquireDbLinkMapping().values()) {
            try {
                CollectionUtils.addAllIgnoreNull(objectDefines, abstractDatabaseLink.buildDefinition());
            }
            catch (UnsupportedGrammarException e) {
                objectDefines.add(new UnsupportedObjectDefine(ObjectType.DBLINK, abstractDatabaseLink.getObjectName(), e.getMessage()));
            }
        }
        return this.sortByDependencies(objectDefines);
    }

    @Override
    public String getQuotaCharacter() {
        return "";
    }

    @Override
    public DropObjectDefine buildDropDefinition() {
        return null;
    }

    public List<ObjectDefine> sortByDependencies(List<ObjectDefine> objectDefines) {
        if (!this.getGlobal().isComputeDependencies()) {
            return objectDefines;
        }
        List<? extends AbstractDependency> deps = this.acquireDependencies();
        if (CollectionUtils.isEmpty(deps) || CollectionUtils.isEmpty(objectDefines)) {
            return objectDefines;
        }
        ObjectRelationGraph graph = new ObjectRelationGraph(deps.size());
        for (AbstractDependency abstractDependency : deps) {
            StringBuilder predecessor = abstractDependency.buildPredecessor();
            StringBuilder successor = abstractDependency.buildSuccessor();
            if (predecessor.toString().equals(successor.toString())) continue;
            graph.add(abstractDependency.buildPredecessor(), abstractDependency.buildSuccessor());
        }
        return graph.groupByDepthFirst(objectDefines);
    }
}

