/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.obtools.dbdiff.model;

import com.oceanbase.obtools.dbdiff.model.AbstractOwnership;
import com.oceanbase.obtools.dbdiff.model.AbstractSchema;

public abstract class AbstractDependency
extends AbstractOwnership {
    private String objType;
    private String objName;
    private String refObjType;
    private String refObjOwner;
    private String refObjName;

    public AbstractDependency(AbstractSchema schema) {
        super(schema);
    }

    public StringBuilder buildPredecessor() {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + this.getObjType() + "]");
        if (super.getGlobal().withSchema()) {
            sb.append(this.getSchemaName()).append(".");
        }
        return sb.append(this.getObjName());
    }

    public StringBuilder buildSuccessor() {
        StringBuilder sb = new StringBuilder();
        sb.append("[" + this.getRefObjType() + "]");
        if (super.getGlobal().withSchema()) {
            sb.append(this.getSchemaName()).append(".");
        }
        return sb.append(this.getRefObjName());
    }

    public String getObjType() {
        return this.objType;
    }

    public void setObjType(String objType) {
        this.objType = objType;
    }

    public String getObjName() {
        return this.objName;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }

    public String getRefObjType() {
        return this.refObjType;
    }

    public void setRefObjType(String refObjType) {
        this.refObjType = refObjType;
    }

    public String getRefObjOwner() {
        return this.refObjOwner;
    }

    public void setRefObjOwner(String refObjOwner) {
        this.refObjOwner = refObjOwner;
    }

    public String getRefObjName() {
        return this.refObjName;
    }

    public void setRefObjName(String refObjName) {
        this.refObjName = refObjName;
    }
}

